/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.net.Uri;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BrowserSwitchException;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

public class BrowserSwitchRequest {
    private static final String KEY_REQUEST_CODE = "requestCode";
    private static final String KEY_URL = "url";
    private static final String KEY_RETURN_URL_SCHEME = "returnUrlScheme";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_APP_LINK_URI = "appLinkUri";
    private final Uri url;
    private final int requestCode;
    private final JSONObject metadata;
    @VisibleForTesting(otherwise=3)
    public final String returnUrlScheme;
    private Uri appLinkUri;

    @NonNull
    static BrowserSwitchRequest fromBase64EncodedJSON(@NonNull String base64EncodedRequest) throws BrowserSwitchException {
        byte[] data = Base64.decode((String)base64EncodedRequest, (int)0);
        String requestJSONString = new String(data, StandardCharsets.UTF_8);
        try {
            JSONObject requestJSON = new JSONObject(requestJSONString);
            Uri appLinkUri = null;
            if (requestJSON.has(KEY_APP_LINK_URI)) {
                appLinkUri = Uri.parse((String)requestJSON.getString(KEY_APP_LINK_URI));
            }
            return new BrowserSwitchRequest(requestJSON.getInt(KEY_REQUEST_CODE), Uri.parse((String)requestJSON.getString(KEY_URL)), requestJSON.optJSONObject(KEY_METADATA), requestJSON.optString(KEY_RETURN_URL_SCHEME), appLinkUri);
        }
        catch (JSONException e) {
            throw new BrowserSwitchException("Unable to deserialize browser switch state.", (Exception)((Object)e));
        }
    }

    @VisibleForTesting(otherwise=3)
    public BrowserSwitchRequest(int requestCode, Uri url, JSONObject metadata, String returnUrlScheme, Uri appLinkUri) {
        this.url = url;
        this.requestCode = requestCode;
        this.metadata = metadata;
        this.returnUrlScheme = returnUrlScheme;
        this.appLinkUri = appLinkUri;
    }

    @VisibleForTesting(otherwise=3)
    public Uri getUrl() {
        return this.url;
    }

    @VisibleForTesting(otherwise=3)
    public int getRequestCode() {
        return this.requestCode;
    }

    @VisibleForTesting(otherwise=3)
    public JSONObject getMetadata() {
        return this.metadata;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Uri getAppLinkUri() {
        return this.appLinkUri;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setAppLinkUri(@Nullable Uri appLinkUri) {
        this.appLinkUri = appLinkUri;
    }

    @NonNull
    String toBase64EncodedJSON() throws BrowserSwitchException {
        try {
            JSONObject requestJSON = new JSONObject().put(KEY_REQUEST_CODE, this.requestCode).put(KEY_URL, (Object)this.url.toString()).putOpt(KEY_RETURN_URL_SCHEME, (Object)this.returnUrlScheme).putOpt(KEY_METADATA, (Object)this.metadata).putOpt(KEY_APP_LINK_URI, (Object)this.appLinkUri);
            byte[] requestJSONBytes = requestJSON.toString().getBytes(StandardCharsets.UTF_8);
            return Base64.encodeToString((byte[])requestJSONBytes, (int)0);
        }
        catch (JSONException e) {
            throw new BrowserSwitchException("Unable to serialize browser switch state.", (Exception)((Object)e));
        }
    }

    boolean matchesDeepLinkUrlScheme(@NonNull Uri url) {
        return url.getScheme() != null && url.getScheme().equalsIgnoreCase(this.returnUrlScheme);
    }

    boolean matchesAppLinkUri(@NonNull Uri uri) {
        return this.appLinkUri != null && uri.getScheme().equals(this.appLinkUri.getScheme()) && uri.getHost().equals(this.appLinkUri.getHost());
    }
}

