/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import java.util.ArrayList;
import java.util.List;

class BrowserSwitchInspector {
    BrowserSwitchInspector() {
    }

    boolean isDeviceConfiguredForDeepLinking(Context context, String returnUrlScheme) {
        String browserSwitchUrl = String.format("%s://", returnUrlScheme);
        Intent deepLinkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)browserSwitchUrl));
        deepLinkIntent.addCategory("android.intent.category.DEFAULT");
        deepLinkIntent.addCategory("android.intent.category.BROWSABLE");
        return this.canResolveActivityForIntent(context, deepLinkIntent);
    }

    boolean deviceHasBrowser(Context context) {
        Intent browserSwitchIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://"));
        return this.canResolveActivityForIntent(context, browserSwitchIntent);
    }

    boolean deviceHasChromeCustomTabs(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent activityIntent = new Intent().setAction("android.intent.action.VIEW").addCategory("android.intent.category.BROWSABLE").setData(Uri.parse((String)"https://"));
        List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
        ArrayList<ResolveInfo> packagesSupportingCustomTabs = new ArrayList<ResolveInfo>();
        for (ResolveInfo info : resolvedActivityList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(info.activityInfo.packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            packagesSupportingCustomTabs.add(info);
        }
        return !packagesSupportingCustomTabs.isEmpty();
    }

    private boolean canResolveActivityForIntent(Context context, Intent intent) {
        return !context.getPackageManager().queryIntentActivities(intent, 0).isEmpty();
    }
}

