/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.braintreepayments.api.BrowserSwitchException;
import com.braintreepayments.api.BrowserSwitchInspector;
import com.braintreepayments.api.BrowserSwitchOptions;
import com.braintreepayments.api.BrowserSwitchPersistentStore;
import com.braintreepayments.api.BrowserSwitchRequest;
import com.braintreepayments.api.BrowserSwitchResult;
import com.braintreepayments.api.ChromeCustomTabsInternalClient;
import com.braintreepayments.api.browserswitch.R;
import org.json.JSONObject;

public class BrowserSwitchClient {
    private final BrowserSwitchInspector browserSwitchInspector;
    private final BrowserSwitchPersistentStore persistentStore;
    private final ChromeCustomTabsInternalClient customTabsInternalClient;

    public BrowserSwitchClient() {
        this(new BrowserSwitchInspector(), BrowserSwitchPersistentStore.getInstance(), new ChromeCustomTabsInternalClient());
    }

    @VisibleForTesting
    BrowserSwitchClient(BrowserSwitchInspector browserSwitchInspector, BrowserSwitchPersistentStore persistentStore, ChromeCustomTabsInternalClient customTabsInternalClient) {
        this.browserSwitchInspector = browserSwitchInspector;
        this.persistentStore = persistentStore;
        this.customTabsInternalClient = customTabsInternalClient;
    }

    public void start(@NonNull FragmentActivity activity, @NonNull BrowserSwitchOptions browserSwitchOptions) throws BrowserSwitchException {
        this.assertCanPerformBrowserSwitch(activity, browserSwitchOptions);
        Context appContext = activity.getApplicationContext();
        Uri browserSwitchUrl = browserSwitchOptions.getUrl();
        int requestCode = browserSwitchOptions.getRequestCode();
        String returnUrlScheme = browserSwitchOptions.getReturnUrlScheme();
        JSONObject metadata = browserSwitchOptions.getMetadata();
        BrowserSwitchRequest request = new BrowserSwitchRequest(requestCode, browserSwitchUrl, metadata, returnUrlScheme, true);
        this.persistentStore.putActiveRequest(request, appContext);
        if (activity.isFinishing()) {
            String activityFinishingMessage = "Unable to start browser switch while host Activity is finishing.";
            throw new BrowserSwitchException(activityFinishingMessage);
        }
        if (this.browserSwitchInspector.deviceHasChromeCustomTabs(appContext)) {
            boolean launchAsNewTask = browserSwitchOptions.isLaunchAsNewTask();
            this.customTabsInternalClient.launchUrl((Context)activity, browserSwitchUrl, launchAsNewTask);
        } else {
            Intent launchUrlInBrowser = new Intent("android.intent.action.VIEW", browserSwitchUrl);
            try {
                activity.startActivity(launchUrlInBrowser);
            }
            catch (ActivityNotFoundException e) {
                throw new BrowserSwitchException("Unable to start browser switch without a web browser.");
            }
        }
    }

    void assertCanPerformBrowserSwitch(FragmentActivity activity, BrowserSwitchOptions browserSwitchOptions) throws BrowserSwitchException {
        Context appContext = activity.getApplicationContext();
        int requestCode = browserSwitchOptions.getRequestCode();
        String returnUrlScheme = browserSwitchOptions.getReturnUrlScheme();
        String errorMessage = null;
        if (!this.isValidRequestCode(requestCode)) {
            errorMessage = activity.getString(R.string.error_request_code_invalid);
        } else if (returnUrlScheme == null) {
            errorMessage = activity.getString(R.string.error_return_url_required);
        } else if (!this.browserSwitchInspector.isDeviceConfiguredForDeepLinking(appContext, returnUrlScheme)) {
            errorMessage = activity.getString(R.string.error_device_not_configured_for_deep_link);
        }
        if (errorMessage != null) {
            throw new BrowserSwitchException(errorMessage);
        }
    }

    private boolean isValidRequestCode(int requestCode) {
        return requestCode != Integer.MIN_VALUE;
    }

    public BrowserSwitchResult deliverResult(@NonNull FragmentActivity activity) {
        BrowserSwitchResult result = null;
        Context appContext = activity.getApplicationContext();
        BrowserSwitchRequest request = this.persistentStore.getActiveRequest(appContext);
        if (request != null && (result = this.getResult(activity)) != null) {
            int status = result.getStatus();
            switch (status) {
                case 1: {
                    this.persistentStore.clearActiveRequest(appContext);
                    break;
                }
                case 2: {
                    request.setShouldNotifyCancellation(false);
                    this.persistentStore.putActiveRequest(request, (Context)activity);
                }
            }
        }
        return result;
    }

    public BrowserSwitchResult getResult(@NonNull FragmentActivity activity) {
        Intent intent = activity.getIntent();
        Context appContext = activity.getApplicationContext();
        BrowserSwitchRequest request = this.persistentStore.getActiveRequest(appContext);
        if (request == null || intent == null) {
            return null;
        }
        BrowserSwitchResult result = null;
        Uri deepLinkUrl = intent.getData();
        if (deepLinkUrl != null && request.matchesDeepLinkUrlScheme(deepLinkUrl)) {
            result = new BrowserSwitchResult(1, request, deepLinkUrl);
        } else if (request.getShouldNotifyCancellation()) {
            result = new BrowserSwitchResult(2, request);
        }
        return result;
    }

    @Nullable
    public BrowserSwitchResult parseResult(@NonNull Context context, int requestCode, @Nullable Intent intent) {
        Uri deepLinkUrl;
        BrowserSwitchRequest request;
        BrowserSwitchResult result = null;
        if (intent != null && intent.getData() != null && (request = this.persistentStore.getActiveRequest(context.getApplicationContext())) != null && request.getRequestCode() == requestCode && request.matchesDeepLinkUrlScheme(deepLinkUrl = intent.getData())) {
            result = new BrowserSwitchResult(1, request, deepLinkUrl);
        }
        return result;
    }

    public void clearActiveRequests(@NonNull Context context) {
        this.persistentStore.clearActiveRequest(context.getApplicationContext());
    }

    public BrowserSwitchResult getResultFromCache(@NonNull Context context) {
        return this.persistentStore.getActiveResult(context.getApplicationContext());
    }

    public BrowserSwitchResult deliverResultFromCache(@NonNull Context context) {
        BrowserSwitchResult result = this.getResultFromCache(context);
        if (result != null) {
            this.persistentStore.removeAll(context.getApplicationContext());
        }
        return result;
    }

    public void captureResult(@NonNull FragmentActivity activity) {
        Intent intent = activity.getIntent();
        Context appContext = activity.getApplicationContext();
        BrowserSwitchRequest request = this.persistentStore.getActiveRequest(appContext);
        if (request == null || intent == null) {
            return;
        }
        Uri deepLinkUrl = intent.getData();
        if (deepLinkUrl != null) {
            BrowserSwitchResult result = new BrowserSwitchResult(1, request, deepLinkUrl);
            this.persistentStore.putActiveResult(result, activity.getApplicationContext());
        }
    }
}

