/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxLogger;
import com.box.sdk.ProgressInputStream;
import com.box.sdk.ProgressListener;
import com.box.sdk.StandardCharsets;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.ParseException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BoxAPIResponse
implements Closeable {
    private static final int BUFFER_SIZE = 8192;
    private static final BoxLogger LOGGER = BoxLogger.defaultLogger();
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final long contentLength;
    private final String contentType;
    private final String requestMethod;
    private final String requestUrl;
    private int responseCode;
    private String bodyString;
    private InputStream rawInputStream;
    private InputStream inputStream;

    public BoxAPIResponse() {
        this.contentLength = 0L;
        this.contentType = null;
        this.requestMethod = null;
        this.requestUrl = null;
    }

    public BoxAPIResponse(int responseCode, String requestMethod, String requestUrl, Map<String, List<String>> headers) {
        this(responseCode, requestMethod, requestUrl, headers, null, null, 0L);
    }

    public BoxAPIResponse(int code, String requestMethod, String requestUrl, Map<String, List<String>> headers, InputStream body, String contentType, long contentLength) {
        this.responseCode = code;
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        if (headers != null) {
            this.headers.putAll(headers);
        }
        this.rawInputStream = body;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.storeBodyResponse(body);
        if (!BoxAPIResponse.isSuccess(this.responseCode)) {
            this.logErrorResponse(this.responseCode);
            throw new BoxAPIResponseException("The API returned an error code", this.responseCode, null, headers);
        }
        this.logResponse();
    }

    private void storeBodyResponse(InputStream body) {
        try {
            if (this.contentType != null && body != null && this.contentType.contains("application/json") && body.available() > 0) {
                InputStreamReader reader = new InputStreamReader(this.getBody(), StandardCharsets.UTF_8);
                StringBuilder builder = new StringBuilder();
                char[] buffer = new char[8192];
                int read = reader.read(buffer, 0, 8192);
                while (read != -1) {
                    builder.append(buffer, 0, read);
                    read = reader.read(buffer, 0, 8192);
                }
                reader.close();
                this.disconnect();
                this.bodyString = builder.toString();
                this.rawInputStream = new ByteArrayInputStream(this.bodyString.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read body stream", e);
        }
    }

    private static boolean isSuccess(int responseCode) {
        return responseCode >= 200 && responseCode < 400;
    }

    static BoxAPIResponse toBoxResponse(Response response) {
        if (!response.isSuccessful() && !response.isRedirect()) {
            throw new BoxAPIResponseException("The API returned an error code", response.code(), Optional.ofNullable(response.body()).map(body -> {
                try {
                    return body.string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).orElse("Body was null"), response.headers().toMultimap());
        }
        ResponseBody responseBody = response.body();
        if (responseBody.contentLength() == 0L || responseBody.contentType() == null) {
            return new BoxAPIResponse(response.code(), response.request().method(), response.request().url().toString(), response.headers().toMultimap());
        }
        if (responseBody != null && responseBody.contentType() != null && responseBody.contentType().toString().contains("application/json")) {
            String bodyAsString = "";
            try {
                bodyAsString = responseBody.string();
                return new BoxJSONResponse(response.code(), response.request().method(), response.request().url().toString(), response.headers().toMultimap(), Json.parse((String)bodyAsString).asObject());
            }
            catch (ParseException e) {
                throw new BoxAPIException(String.format("Error parsing JSON:\n%s", bodyAsString), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting response to string", e);
            }
        }
        return new BoxAPIResponse(response.code(), response.request().method(), response.request().url().toString(), response.headers().toMultimap(), responseBody.byteStream(), Optional.ofNullable(responseBody.contentType()).map(MediaType::toString).orElse(null), responseBody.contentLength());
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getHeaderField(String fieldName) {
        return Optional.ofNullable(this.headers.get(fieldName)).map(l -> (String)l.get(0)).orElse("");
    }

    public InputStream getBody() {
        return this.getBody(null);
    }

    public InputStream getBody(ProgressListener listener) {
        if (this.inputStream == null) {
            this.inputStream = listener == null ? this.rawInputStream : new ProgressInputStream(this.rawInputStream, listener, this.getContentLength());
        }
        return this.inputStream;
    }

    public void disconnect() {
        this.close();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Response").append(lineSeparator).append(this.requestMethod).append(' ').append(this.requestUrl).append(lineSeparator).append(this.contentType != null ? "Content-Type: " + this.contentType + lineSeparator : "").append(this.headers.isEmpty() ? "" : "Headers:" + lineSeparator);
        this.headers.entrySet().stream().filter(Objects::nonNull).forEach(e -> builder.append(String.format("%s: [%s]%s", ((String)e.getKey()).toLowerCase(), e.getValue(), lineSeparator)));
        String bodyString = this.bodyToString();
        if (bodyString != null && !bodyString.equals("")) {
            builder.append("Body:").append(lineSeparator).append(bodyString);
        }
        return builder.toString().trim();
    }

    @Override
    public void close() {
        try {
            if (this.inputStream == null && this.rawInputStream != null) {
                this.rawInputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't finish closing the connection to the Box API due to a network error or because the stream was already closed.", e);
        }
    }

    protected String bodyToString() {
        return this.bodyString;
    }

    private void logResponse() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
    }

    private void logErrorResponse(int responseCode) {
        if (responseCode < 500 && LOGGER.isWarnEnabled()) {
            LOGGER.warn(this.toString());
        }
        if (responseCode >= 500 && LOGGER.isErrorEnabled()) {
            LOGGER.error(this.toString());
        }
    }
}

