/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.files;

import com.box.sdkgen.box.errors.BoxSDKError;
import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.files.CopyFileHeaders;
import com.box.sdkgen.managers.files.CopyFileQueryParams;
import com.box.sdkgen.managers.files.CopyFileRequestBody;
import com.box.sdkgen.managers.files.DeleteFileByIdHeaders;
import com.box.sdkgen.managers.files.GetFileByIdHeaders;
import com.box.sdkgen.managers.files.GetFileByIdQueryParams;
import com.box.sdkgen.managers.files.GetFileThumbnailByIdExtension;
import com.box.sdkgen.managers.files.GetFileThumbnailByIdHeaders;
import com.box.sdkgen.managers.files.GetFileThumbnailByIdQueryParams;
import com.box.sdkgen.managers.files.GetFileThumbnailUrlExtension;
import com.box.sdkgen.managers.files.GetFileThumbnailUrlHeaders;
import com.box.sdkgen.managers.files.GetFileThumbnailUrlQueryParams;
import com.box.sdkgen.managers.files.UpdateFileByIdHeaders;
import com.box.sdkgen.managers.files.UpdateFileByIdQueryParams;
import com.box.sdkgen.managers.files.UpdateFileByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.filefull.FileFull;
import com.box.sdkgen.serialization.json.JsonManager;
import java.io.InputStream;
import java.util.Map;

public class FilesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FilesManager() {
        this.networkSession = new NetworkSession();
    }

    protected FilesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public FileFull getFileById(String fileId) {
        return this.getFileById(fileId, new GetFileByIdQueryParams(), new GetFileByIdHeaders());
    }

    public FileFull getFileById(String fileId, GetFileByIdQueryParams queryParams) {
        return this.getFileById(fileId, queryParams, new GetFileByIdHeaders());
    }

    public FileFull getFileById(String fileId, GetFileByIdHeaders headers) {
        return this.getFileById(fileId, new GetFileByIdQueryParams(), headers);
    }

    public FileFull getFileById(String fileId, GetFileByIdQueryParams queryParams, GetFileByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-none-match", UtilsManager.convertToString(headers.getIfNoneMatch())), UtilsManager.entryOf("boxapi", UtilsManager.convertToString(headers.getBoxapi())), UtilsManager.entryOf("x-rep-hints", UtilsManager.convertToString(headers.getXRepHints()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public FileFull updateFileById(String fileId) {
        return this.updateFileById(fileId, new UpdateFileByIdRequestBody(), new UpdateFileByIdQueryParams(), new UpdateFileByIdHeaders());
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdRequestBody requestBody) {
        return this.updateFileById(fileId, requestBody, new UpdateFileByIdQueryParams(), new UpdateFileByIdHeaders());
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdQueryParams queryParams) {
        return this.updateFileById(fileId, new UpdateFileByIdRequestBody(), queryParams, new UpdateFileByIdHeaders());
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdRequestBody requestBody, UpdateFileByIdQueryParams queryParams) {
        return this.updateFileById(fileId, requestBody, queryParams, new UpdateFileByIdHeaders());
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdHeaders headers) {
        return this.updateFileById(fileId, new UpdateFileByIdRequestBody(), new UpdateFileByIdQueryParams(), headers);
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdRequestBody requestBody, UpdateFileByIdHeaders headers) {
        return this.updateFileById(fileId, requestBody, new UpdateFileByIdQueryParams(), headers);
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdQueryParams queryParams, UpdateFileByIdHeaders headers) {
        return this.updateFileById(fileId, new UpdateFileByIdRequestBody(), queryParams, headers);
    }

    public FileFull updateFileById(String fileId, UpdateFileByIdRequestBody requestBody, UpdateFileByIdQueryParams queryParams, UpdateFileByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId)), "PUT").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public void deleteFileById(String fileId) {
        this.deleteFileById(fileId, new DeleteFileByIdHeaders());
    }

    public void deleteFileById(String fileId, DeleteFileByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("if-match", UtilsManager.convertToString(headers.getIfMatch()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public FileFull copyFile(String fileId, CopyFileRequestBody requestBody) {
        return this.copyFile(fileId, requestBody, new CopyFileQueryParams(), new CopyFileHeaders());
    }

    public FileFull copyFile(String fileId, CopyFileRequestBody requestBody, CopyFileQueryParams queryParams) {
        return this.copyFile(fileId, requestBody, queryParams, new CopyFileHeaders());
    }

    public FileFull copyFile(String fileId, CopyFileRequestBody requestBody, CopyFileHeaders headers) {
        return this.copyFile(fileId, requestBody, new CopyFileQueryParams(), headers);
    }

    public FileFull copyFile(String fileId, CopyFileRequestBody requestBody, CopyFileQueryParams queryParams, CopyFileHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/copy"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), FileFull.class);
    }

    public String getFileThumbnailUrl(String fileId, GetFileThumbnailUrlExtension extension) {
        return this.getFileThumbnailUrl(fileId, extension, new GetFileThumbnailUrlQueryParams(), new GetFileThumbnailUrlHeaders());
    }

    public String getFileThumbnailUrl(String fileId, GetFileThumbnailUrlExtension extension, GetFileThumbnailUrlQueryParams queryParams) {
        return this.getFileThumbnailUrl(fileId, extension, queryParams, new GetFileThumbnailUrlHeaders());
    }

    public String getFileThumbnailUrl(String fileId, GetFileThumbnailUrlExtension extension, GetFileThumbnailUrlHeaders headers) {
        return this.getFileThumbnailUrl(fileId, extension, new GetFileThumbnailUrlQueryParams(), headers);
    }

    public String getFileThumbnailUrl(String fileId, GetFileThumbnailUrlExtension extension, GetFileThumbnailUrlQueryParams queryParams, GetFileThumbnailUrlHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("min_height", UtilsManager.convertToString(queryParams.getMinHeight())), UtilsManager.entryOf("min_width", UtilsManager.convertToString(queryParams.getMinWidth())), UtilsManager.entryOf("max_height", UtilsManager.convertToString(queryParams.getMaxHeight())), UtilsManager.entryOf("max_width", UtilsManager.convertToString(queryParams.getMaxWidth()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/thumbnail.", UtilsManager.convertToString(extension)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).followRedirects(false).build());
        if (response.getHeaders().containsKey("location")) {
            return response.getHeaders().get("location");
        }
        if (response.getHeaders().containsKey("Location")) {
            return response.getHeaders().get("Location");
        }
        throw new BoxSDKError("No location header in response");
    }

    public InputStream getFileThumbnailById(String fileId, GetFileThumbnailByIdExtension extension) {
        return this.getFileThumbnailById(fileId, extension, new GetFileThumbnailByIdQueryParams(), new GetFileThumbnailByIdHeaders());
    }

    public InputStream getFileThumbnailById(String fileId, GetFileThumbnailByIdExtension extension, GetFileThumbnailByIdQueryParams queryParams) {
        return this.getFileThumbnailById(fileId, extension, queryParams, new GetFileThumbnailByIdHeaders());
    }

    public InputStream getFileThumbnailById(String fileId, GetFileThumbnailByIdExtension extension, GetFileThumbnailByIdHeaders headers) {
        return this.getFileThumbnailById(fileId, extension, new GetFileThumbnailByIdQueryParams(), headers);
    }

    public InputStream getFileThumbnailById(String fileId, GetFileThumbnailByIdExtension extension, GetFileThumbnailByIdQueryParams queryParams, GetFileThumbnailByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("min_height", UtilsManager.convertToString(queryParams.getMinHeight())), UtilsManager.entryOf("min_width", UtilsManager.convertToString(queryParams.getMinWidth())), UtilsManager.entryOf("max_height", UtilsManager.convertToString(queryParams.getMaxHeight())), UtilsManager.entryOf("max_width", UtilsManager.convertToString(queryParams.getMaxWidth()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/files/", UtilsManager.convertToString(fileId), "/thumbnail.", UtilsManager.convertToString(extension)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.BINARY).auth(this.auth).networkSession(this.networkSession).build());
        if (UtilsManager.convertToString(response.getStatus()).equals("202")) {
            return null;
        }
        return response.getContent();
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FilesManager build() {
            return new FilesManager(this);
        }
    }
}

