package com.box.sdkgen.managers.listcollaborations;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class GetFileCollaborationsHeaders {

  public Map<String, String> extraHeaders;

  public GetFileCollaborationsHeaders() {
    this.extraHeaders = mapOf();
  }

  protected GetFileCollaborationsHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public GetFileCollaborationsHeaders build() {
      return new GetFileCollaborationsHeaders(this);
    }
  }
}
