package com.box.sdkgen.managers.fileclassifications;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class DeleteClassificationFromFileHeaders {

  public Map<String, String> extraHeaders;

  public DeleteClassificationFromFileHeaders() {
    this.extraHeaders = mapOf();
  }

  protected DeleteClassificationFromFileHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public DeleteClassificationFromFileHeaders build() {
      return new DeleteClassificationFromFileHeaders(this);
    }
  }
}
