package com.box.sdkgen.managers.events;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class GetEventStreamHeaders {

  public Map<String, String> extraHeaders;

  public GetEventStreamHeaders() {
    this.extraHeaders = mapOf();
  }

  protected GetEventStreamHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public GetEventStreamHeaders build() {
      return new GetEventStreamHeaders(this);
    }
  }
}
