/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.util;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.util.Utils;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof QTESLAPublicKeyParameters) {
            QTESLAPublicKeyParameters qTESLAPublicKeyParameters = (QTESLAPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(qTESLAPublicKeyParameters.getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, qTESLAPublicKeyParameters.getPublicData());
        }
        if (asymmetricKeyParameter instanceof SPHINCSPublicKeyParameters) {
            SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters = (SPHINCSPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(sPHINCSPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, sPHINCSPublicKeyParameters.getKeyData());
        }
        if (asymmetricKeyParameter instanceof NHPublicKeyParameters) {
            NHPublicKeyParameters nHPublicKeyParameters = (NHPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, nHPublicKeyParameters.getPubData());
        }
        if (asymmetricKeyParameter instanceof XMSSPublicKeyParameters) {
            XMSSPublicKeyParameters xMSSPublicKeyParameters = (XMSSPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(xMSSPublicKeyParameters.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(xMSSPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(xMSSPublicKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getRoot()));
        }
        if (asymmetricKeyParameter instanceof XMSSMTPublicKeyParameters) {
            XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = (XMSSMTPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(xMSSMTPublicKeyParameters.getParameters().getHeight(), xMSSMTPublicKeyParameters.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(xMSSMTPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(xMSSMTPublicKeyParameters.getPublicSeed(), xMSSMTPublicKeyParameters.getRoot()));
        }
        throw new IOException("key parameters not recognized");
    }
}

