/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.ASN1Set;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cms.AttributeTable;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.AuthAttributesProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSEnvelopedHelper;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSException;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSSecureReadable;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.CMSUtils;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.OriginatorInformation;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.cms.RecipientInformationStore;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSAuthEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInformation originatorInfo;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSAuthEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvelopedData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        if (authEnvelopedData.getOriginatorInfo() != null) {
            this.originatorInfo = new OriginatorInformation(authEnvelopedData.getOriginatorInfo());
        }
        ASN1Set aSN1Set = authEnvelopedData.getRecipientInfos();
        final EncryptedContentInfo encryptedContentInfo = authEnvelopedData.getAuthEncryptedContentInfo();
        this.authEncAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
        CMSSecureReadable cMSSecureReadable = new CMSSecureReadable(){

            public InputStream getInputStream() throws IOException, CMSException {
                return new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets());
            }
        };
        this.authAttrs = authEnvelopedData.getAuthAttrs();
        this.mac = authEnvelopedData.getMac().getOctets();
        this.unauthAttrs = authEnvelopedData.getUnauthAttrs();
        this.recipientInfoStore = this.authAttrs != null ? CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.authEncAlg, cMSSecureReadable, new AuthAttributesProvider(){

            public ASN1Set getAuthAttributes() {
                return CMSAuthEnvelopedData.this.authAttrs;
            }

            public boolean isAead() {
                return true;
            }
        }) : CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.authEncAlg, cMSSecureReadable);
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getAuthAttrs() {
        if (this.authAttrs == null) {
            return null;
        }
        return new AttributeTable(this.authAttrs);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.unauthAttrs == null) {
            return null;
        }
        return new AttributeTable(this.unauthAttrs);
    }

    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }
}

