/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.api.model.ServiceGlobalModeOptions;
import com.github.dockerjava.api.model.ServiceMode;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import java.io.Serializable;

public class ServiceModeConfig
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Replicated")
    private ServiceReplicatedModeOptions replicated;
    @JsonProperty(value="Global")
    private ServiceGlobalModeOptions global;

    @CheckForNull
    public ServiceMode getMode() {
        if (this.replicated != null) {
            return ServiceMode.REPLICATED;
        }
        if (this.global != null) {
            return ServiceMode.GLOBAL;
        }
        return null;
    }

    @CheckForNull
    public ServiceReplicatedModeOptions getReplicated() {
        return this.replicated;
    }

    public ServiceModeConfig withReplicated(ServiceReplicatedModeOptions replicated) {
        if (replicated != null && this.global != null) {
            throw new IllegalStateException("Cannot set both replicated and global mode");
        }
        this.replicated = replicated;
        return this;
    }

    @CheckForNull
    public ServiceGlobalModeOptions getGlobal() {
        return this.global;
    }

    public ServiceModeConfig withGlobal(ServiceGlobalModeOptions global) {
        if (global != null && this.replicated != null) {
            throw new IllegalStateException("Cannot set both global and replicated mode");
        }
        this.global = global;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceModeConfig)) {
            return false;
        }
        ServiceModeConfig other = (ServiceModeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServiceReplicatedModeOptions this$replicated = this.getReplicated();
        ServiceReplicatedModeOptions other$replicated = other.getReplicated();
        if (this$replicated == null ? other$replicated != null : !((Object)this$replicated).equals(other$replicated)) {
            return false;
        }
        ServiceGlobalModeOptions this$global = this.getGlobal();
        ServiceGlobalModeOptions other$global = other.getGlobal();
        return !(this$global == null ? other$global != null : !((Object)this$global).equals(other$global));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceModeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServiceReplicatedModeOptions $replicated = this.getReplicated();
        result = result * 59 + ($replicated == null ? 43 : ((Object)$replicated).hashCode());
        ServiceGlobalModeOptions $global = this.getGlobal();
        result = result * 59 + ($global == null ? 43 : ((Object)$global).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceModeConfig(replicated=" + this.getReplicated() + ", global=" + this.getGlobal() + ")";
    }
}

