/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class ContainerNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="IPAMConfig")
    private Ipam ipamConfig;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="Aliases")
    private List<String> aliases;
    @JsonProperty(value="NetworkID")
    private String networkID;
    @JsonProperty(value="EndpointID")
    private String endpointId;
    @JsonProperty(value="Gateway")
    private String gateway;
    @JsonProperty(value="IPAddress")
    private String ipAddress;
    @JsonProperty(value="IPPrefixLen")
    private Integer ipPrefixLen;
    @JsonProperty(value="IPv6Gateway")
    private String ipV6Gateway;
    @JsonProperty(value="GlobalIPv6Address")
    private String globalIPv6Address;
    @JsonProperty(value="GlobalIPv6PrefixLen")
    private Integer globalIPv6PrefixLen;
    @JsonProperty(value="MacAddress")
    private String macAddress;

    @CheckForNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public ContainerNetwork withAliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public ContainerNetwork withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    @CheckForNull
    public String getEndpointId() {
        return this.endpointId;
    }

    public ContainerNetwork withEndpointId(String endpointId) {
        this.endpointId = endpointId;
        return this;
    }

    @CheckForNull
    public String getGateway() {
        return this.gateway;
    }

    public ContainerNetwork withGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @CheckForNull
    public String getGlobalIPv6Address() {
        return this.globalIPv6Address;
    }

    public ContainerNetwork withGlobalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
        return this;
    }

    @CheckForNull
    public Integer getGlobalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    public ContainerNetwork withGlobalIPv6PrefixLen(Integer globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        return this;
    }

    @CheckForNull
    public String getIpAddress() {
        return this.ipAddress;
    }

    public ContainerNetwork withIpv4Address(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @CheckForNull
    public Ipam getIpamConfig() {
        return this.ipamConfig;
    }

    public ContainerNetwork withIpamConfig(Ipam ipamConfig) {
        this.ipamConfig = ipamConfig;
        return this;
    }

    @CheckForNull
    public Integer getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public ContainerNetwork withIpPrefixLen(Integer ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
        return this;
    }

    @CheckForNull
    public String getIpV6Gateway() {
        return this.ipV6Gateway;
    }

    public ContainerNetwork withIpV6Gateway(String ipV6Gateway) {
        this.ipV6Gateway = ipV6Gateway;
        return this;
    }

    @CheckForNull
    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    public ContainerNetwork withLinks(List<Link> links) {
        this.links = new Links(links);
        return this;
    }

    public ContainerNetwork withLinks(Link ... links) {
        this.links = new Links(links);
        return this;
    }

    @CheckForNull
    public String getMacAddress() {
        return this.macAddress;
    }

    public ContainerNetwork withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @CheckForNull
    public String getNetworkID() {
        return this.networkID;
    }

    public ContainerNetwork withNetworkID(String networkID) {
        this.networkID = networkID;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerNetwork)) {
            return false;
        }
        ContainerNetwork other = (ContainerNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Ipam this$ipamConfig = this.getIpamConfig();
        Ipam other$ipamConfig = other.getIpamConfig();
        if (this$ipamConfig == null ? other$ipamConfig != null : !this$ipamConfig.equals(other$ipamConfig)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLinks(), other.getLinks())) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        String this$networkID = this.getNetworkID();
        String other$networkID = other.getNetworkID();
        if (this$networkID == null ? other$networkID != null : !this$networkID.equals(other$networkID)) {
            return false;
        }
        String this$endpointId = this.getEndpointId();
        String other$endpointId = other.getEndpointId();
        if (this$endpointId == null ? other$endpointId != null : !this$endpointId.equals(other$endpointId)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        Integer this$ipPrefixLen = this.getIpPrefixLen();
        Integer other$ipPrefixLen = other.getIpPrefixLen();
        if (this$ipPrefixLen == null ? other$ipPrefixLen != null : !((Object)this$ipPrefixLen).equals(other$ipPrefixLen)) {
            return false;
        }
        String this$ipV6Gateway = this.getIpV6Gateway();
        String other$ipV6Gateway = other.getIpV6Gateway();
        if (this$ipV6Gateway == null ? other$ipV6Gateway != null : !this$ipV6Gateway.equals(other$ipV6Gateway)) {
            return false;
        }
        String this$globalIPv6Address = this.getGlobalIPv6Address();
        String other$globalIPv6Address = other.getGlobalIPv6Address();
        if (this$globalIPv6Address == null ? other$globalIPv6Address != null : !this$globalIPv6Address.equals(other$globalIPv6Address)) {
            return false;
        }
        Integer this$globalIPv6PrefixLen = this.getGlobalIPv6PrefixLen();
        Integer other$globalIPv6PrefixLen = other.getGlobalIPv6PrefixLen();
        if (this$globalIPv6PrefixLen == null ? other$globalIPv6PrefixLen != null : !((Object)this$globalIPv6PrefixLen).equals(other$globalIPv6PrefixLen)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        return !(this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerNetwork;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Ipam $ipamConfig = this.getIpamConfig();
        result = result * 59 + ($ipamConfig == null ? 43 : $ipamConfig.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLinks());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        String $networkID = this.getNetworkID();
        result = result * 59 + ($networkID == null ? 43 : $networkID.hashCode());
        String $endpointId = this.getEndpointId();
        result = result * 59 + ($endpointId == null ? 43 : $endpointId.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        Integer $ipPrefixLen = this.getIpPrefixLen();
        result = result * 59 + ($ipPrefixLen == null ? 43 : ((Object)$ipPrefixLen).hashCode());
        String $ipV6Gateway = this.getIpV6Gateway();
        result = result * 59 + ($ipV6Gateway == null ? 43 : $ipV6Gateway.hashCode());
        String $globalIPv6Address = this.getGlobalIPv6Address();
        result = result * 59 + ($globalIPv6Address == null ? 43 : $globalIPv6Address.hashCode());
        Integer $globalIPv6PrefixLen = this.getGlobalIPv6PrefixLen();
        result = result * 59 + ($globalIPv6PrefixLen == null ? 43 : ((Object)$globalIPv6PrefixLen).hashCode());
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        return result;
    }

    public String toString() {
        return "ContainerNetwork(ipamConfig=" + this.getIpamConfig() + ", links=" + Arrays.deepToString(this.getLinks()) + ", aliases=" + this.getAliases() + ", networkID=" + this.getNetworkID() + ", endpointId=" + this.getEndpointId() + ", gateway=" + this.getGateway() + ", ipAddress=" + this.getIpAddress() + ", ipPrefixLen=" + this.getIpPrefixLen() + ", ipV6Gateway=" + this.getIpV6Gateway() + ", globalIPv6Address=" + this.getGlobalIPv6Address() + ", globalIPv6PrefixLen=" + this.getGlobalIPv6PrefixLen() + ", macAddress=" + this.getMacAddress() + ")";
    }

    public static class Ipam
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="IPv4Address")
        private String ipv4Address;
        @JsonProperty(value="IPv6Address")
        private String ipv6Address;

        public String getIpv4Address() {
            return this.ipv4Address;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public Ipam withIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public Ipam withIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }
    }
}

