/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.async.AsyncExecCallback;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.async.AsyncExecChain;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.async.AsyncExecChainHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.async.AsyncExecRuntime;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Contract;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.concurrent.CancellableDependency;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.EntityDetails;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Header;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpRequest;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.message.RequestLine;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.CapacityChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.RequestChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public class H2AsyncMainClientExec
implements AsyncExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(final HttpRequest request, final AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        String exchangeId = scope.exchangeId;
        CancellableDependency operation = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        final AsyncExecRuntime execRuntime = scope.execRuntime;
        if (this.log.isDebugEnabled()) {
            this.log.debug(exchangeId + ": executing " + new RequestLine(request));
        }
        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){
            private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference<Object>(null);

            @Override
            public void releaseResources() {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
            }

            @Override
            public void failed(Exception cause) {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
                execRuntime.markConnectionNonReusable();
                asyncExecCallback.failed(cause);
            }

            @Override
            public void cancel() {
                this.failed(new InterruptedIOException());
            }

            @Override
            public void produceRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
                channel.sendRequest(request, entityProducer, context);
            }

            @Override
            public int available() {
                return entityProducer.available();
            }

            @Override
            public void produce(DataStreamChannel channel) throws IOException {
                entityProducer.produce(channel);
            }

            @Override
            public void consumeInformation(HttpResponse response, HttpContext context) throws HttpException, IOException {
            }

            @Override
            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
                this.entityConsumerRef.set(asyncExecCallback.handleResponse(response, entityDetails));
                if (entityDetails == null) {
                    execRuntime.validateConnection();
                    asyncExecCallback.completed();
                }
            }

            @Override
            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.updateCapacity(capacityChannel);
                } else {
                    capacityChannel.update(Integer.MAX_VALUE);
                }
            }

            @Override
            public void consume(ByteBuffer src) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.consume(src);
                }
            }

            @Override
            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.streamEnd(trailers);
                } else {
                    execRuntime.validateConnection();
                }
                asyncExecCallback.completed();
            }
        };
        if (this.log.isDebugEnabled()) {
            operation.setDependency(execRuntime.execute(exchangeId, new LoggingAsyncClientExchangeHandler(this.log, exchangeId, internalExchangeHandler), clientContext));
        } else {
            operation.setDependency(execRuntime.execute(exchangeId, internalExchangeHandler, clientContext));
        }
    }
}

