/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.NativeUnixSocket;

public class AFUNIXServerSocket
extends ServerSocket {
    private final AFUNIXSocketImpl implementation;
    private AFUNIXSocketAddress boundEndpoint;

    protected AFUNIXServerSocket() throws IOException {
        this.setReuseAddress(true);
        this.implementation = new AFUNIXSocketImpl();
        NativeUnixSocket.initServerImpl(this, this.implementation);
        NativeUnixSocket.setCreatedServer(this);
    }

    public static AFUNIXServerSocket newInstance() throws IOException {
        AFUNIXServerSocket instance = new AFUNIXServerSocket();
        return instance;
    }

    public static AFUNIXServerSocket bindOn(AFUNIXSocketAddress addr) throws IOException {
        AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();
        socket.bind(addr);
        return socket;
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (!(endpoint instanceof AFUNIXSocketAddress)) {
            throw new IOException("Can only bind to endpoints of type " + AFUNIXSocketAddress.class.getName());
        }
        this.implementation.bind(endpoint, this.getReuseAddress() ? -1 : 0);
        this.boundEndpoint = (AFUNIXSocketAddress)endpoint;
        this.implementation.listen(backlog);
    }

    @Override
    public boolean isBound() {
        return this.boundEndpoint != null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.isBound() && !this.implementation.getFD().valid();
    }

    @Override
    public AFUNIXSocket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        AFUNIXSocket as = AFUNIXSocket.newInstance();
        this.implementation.accept(as.impl);
        as.addr = this.boundEndpoint;
        NativeUnixSocket.setConnected(as);
        return as;
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "AFUNIXServerSocket[unbound]";
        }
        return "AFUNIXServerSocket[" + this.boundEndpoint.toString() + "]";
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        this.implementation.close();
    }

    public static boolean isSupported() {
        return NativeUnixSocket.isLoaded();
    }
}

