/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.core.JsonParser;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.core.ObjectCodec;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.dockerjava.api.model.Bind;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Binds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Bind[] binds;

    public Binds(Bind ... binds) {
        this.binds = binds;
    }

    public Bind[] getBinds() {
        return this.binds;
    }

    public static class Deserializer
    extends JsonDeserializer<Binds> {
        @Override
        public Binds deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayList<Bind> binds = new ArrayList<Bind>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator<JsonNode> it = node.elements();
            while (it.hasNext()) {
                JsonNode field = it.next();
                binds.add(Bind.parse(field.asText()));
            }
            return new Binds(binds.toArray(new Bind[0]));
        }
    }

    public static class Serializer
    extends JsonSerializer<Binds> {
        @Override
        public void serialize(Binds binds, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartArray();
            for (Bind bind : binds.getBinds()) {
                jsonGen.writeString(bind.toString());
            }
            jsonGen.writeEndArray();
        }
    }
}

