/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.github.dockerjava.api.model.AuthConfig;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class RegistryAuthLocator
implements GroovyObject {
    private static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    private static final String USER_HOME = "user.home";
    private static final String DOCKER_DIR = ".docker";
    private static final String CONFIG_JSON = "config.json";
    private static final String AUTH_SECTION = "auths";
    private static final String HELPERS_SECTION = "credHelpers";
    private static final String CREDS_STORE_SECTION = "credsStore";
    private static final String DEFAULT_HELPER_PREFIX = "docker-credential-";
    private static final Logger log;
    private final JsonSlurper slurper;
    private final File configFile;
    private final String commandPathPrefix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RegistryAuthLocator(File configFile, String commandPathPrefix) {
        String string;
        File file;
        MetaClass metaClass;
        JsonSlurper jsonSlurper;
        this.slurper = jsonSlurper = new JsonSlurper();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.configFile = file = configFile;
        this.commandPathPrefix = string = commandPathPrefix;
    }

    public RegistryAuthLocator(File configFile) {
        this(configFile, DEFAULT_HELPER_PREFIX);
    }

    public RegistryAuthLocator() {
        this(new File(RegistryAuthLocator.configLocation()), DEFAULT_HELPER_PREFIX);
    }

    public AuthConfig lookupAuthConfig(String image) {
        return this.lookupAuthConfig(image, new AuthConfig());
    }

    public AuthConfig lookupAuthConfig(String image, DockerRegistryCredentials registryCredentials) {
        AuthConfig defaultConfig = this.createAuthConfig(registryCredentials);
        return this.lookupAuthConfig(image, defaultConfig);
    }

    /*
     * Unable to fully structure code
     */
    public AuthConfig lookupAuthConfig(String image, AuthConfig defaultAuthConfig) {
        block8: {
            if (RegistryAuthLocator.isWindows()) {
                RegistryAuthLocator.log.debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"RegistryAuthLocator is not supported on Windows. ", (CharSequence)"Please help test or improve it and update "), (CharSequence)"https://github.com/bmuschko/gradle-docker-plugin/"));
                return defaultAuthConfig;
            }
            repository = RegistryAuthLocator.getRepository(image);
            RegistryAuthLocator.log.debug("Looking up auth config for repository: {}", (Object)repository);
            RegistryAuthLocator.log.debug(StringGroovyMethods.plus((String)"RegistryAuthLocator has configFile: {} ({}) and ", (CharSequence)"commandPathPrefix: {}"), new Object[]{this.configFile, this.configFile.exists() != false ? "exists" : "does not exist", this.commandPathPrefix});
            config = (Map)ScriptBytecodeAdapter.asType((Object)this.slurper.parse(this.configFile), Map.class);
            existingAuthConfig = RegistryAuthLocator.findExistingAuthConfig(config, repository);
            if (!(existingAuthConfig != null)) ** GOTO lbl22
            var6_6 = existingAuthConfig;
            return var6_6;
lbl22:
            // 1 sources

            helperAuthConfig = this.authConfigUsingHelper(config, repository);
            if (!(helperAuthConfig != null)) ** GOTO lbl30
            var8_8 = helperAuthConfig;
            return var8_8;
lbl30:
            // 1 sources

            storeAuthConfig = this.authConfigUsingStore(config, repository);
            if (!(storeAuthConfig != null)) break block8;
            var10_10 = storeAuthConfig;
            try {
                return var10_10;
            }
            catch (Exception ex) {
                RegistryAuthLocator.log.error(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Failure when attempting to lookup auth config ", (CharSequence)"(docker repository: {}, configFile: {}. "), (CharSequence)"Falling back to docker-java default behaviour"), new Object[]{repository, this.configFile, ex});
            }
        }
        return defaultAuthConfig;
    }

    public AuthConfig createAuthConfig(DockerRegistryCredentials registryCredentials) {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withRegistryAddress(ShortTypeHandling.castToString((Object)registryCredentials.getUrl().get()));
        if (registryCredentials.getUsername().isPresent()) {
            authConfig.withUsername(ShortTypeHandling.castToString((Object)registryCredentials.getUsername().get()));
        }
        if (registryCredentials.getPassword().isPresent()) {
            authConfig.withPassword(ShortTypeHandling.castToString((Object)registryCredentials.getPassword().get()));
        }
        if (registryCredentials.getEmail().isPresent()) {
            authConfig.withEmail(ShortTypeHandling.castToString((Object)registryCredentials.getEmail().get()));
        }
        return authConfig;
    }

    private static String configLocation() {
        String defaultDir = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)System.getProperty(USER_HOME), (CharSequence)File.separator), (CharSequence)DOCKER_DIR);
        String dir = ShortTypeHandling.castToString((Object)System.getenv().getOrDefault(DOCKER_CONFIG, defaultDir));
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)dir, (CharSequence)File.separator), (CharSequence)CONFIG_JSON);
    }

    private static String getRepository(String image) {
        int slashIndex = image.indexOf("/");
        if (ScriptBytecodeAdapter.compareEqual((Object)slashIndex, (Object)-1) || !image.substring(0, slashIndex).contains(".") && !image.substring(0, slashIndex).contains(":") && !image.substring(0, slashIndex).equals("localhost")) {
            return "";
        }
        return image.substring(0, slashIndex);
    }

    private static AuthConfig findExistingAuthConfig(Map<String, Object> config, String repository) {
        Map.Entry<String, Object> entry = RegistryAuthLocator.findAuthNode(config, repository);
        if (entry != null && entry.getValue() != null && entry.getValue() instanceof Map) {
            Map authMap = (Map)ScriptBytecodeAdapter.asType((Object)entry.getValue(), Map.class);
            if (authMap.size() > 0) {
                String authJson = JsonOutput.toJson((Object)entry.getValue());
                AuthConfig authCfg = (AuthConfig)ScriptBytecodeAdapter.asType((Object)new JsonSlurper().parseText(authJson), AuthConfig.class);
                return authCfg.withRegistryAddress(ShortTypeHandling.castToString((Object)entry.getKey()));
            }
        }
        log.debug("No existing AuthConfig found");
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private static Map.Entry<String, Object> findAuthNode(Map<String, Object> config, String repository) {
        Map auths = (Map)ScriptBytecodeAdapter.asType((Object)config.get(AUTH_SECTION), Map.class);
        if (auths != null && auths.size() > 0) {
            Map.Entry entry = null;
            Iterator iterator = auths.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                if (!(((String)entry.getKey()).endsWith(StringGroovyMethods.plus((String)"://", (CharSequence)repository)) || ScriptBytecodeAdapter.compareEqual(entry.getKey(), (Object)repository))) continue;
                return entry;
            }
        }
        return (Map.Entry)ScriptBytecodeAdapter.castToType(null, Map.Entry.class);
    }

    private AuthConfig authConfigUsingHelper(Map<String, Object> config, String repository) {
        Map credHelpers = (Map)ScriptBytecodeAdapter.asType((Object)config.get(HELPERS_SECTION), Map.class);
        if (credHelpers != null && credHelpers.size() > 0) {
            Object helperNode = credHelpers.get(repository);
            if (helperNode != null && helperNode instanceof String) {
                String helper = (String)ScriptBytecodeAdapter.asType(helperNode, String.class);
                return this.runCredentialProvider(repository, helper);
            }
        }
        log.debug("No helper found in the {} section", (Object)HELPERS_SECTION);
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private AuthConfig runCredentialProvider(String hostName, String credHelper) {
        String credentialHelperName = StringGroovyMethods.plus((String)this.commandPathPrefix, (CharSequence)credHelper);
        String data = RegistryAuthLocator.runCommand(hostName, credentialHelperName);
        Map helperResponse = (Map)ScriptBytecodeAdapter.asType((Object)this.slurper.parseText(data), Map.class);
        log.debug("Credential helper provided auth config for: {}", (Object)hostName);
        return new AuthConfig().withRegistryAddress(ShortTypeHandling.castToString(helperResponse.get("ServerURL"))).withUsername(ShortTypeHandling.castToString(helperResponse.get("Username"))).withPassword(ShortTypeHandling.castToString(helperResponse.get("Secret")));
    }

    private AuthConfig authConfigUsingStore(Map<String, Object> config, String repository) {
        Object credsStoreNode = config.get(CREDS_STORE_SECTION);
        if (credsStoreNode != null && credsStoreNode instanceof String) {
            String credsStore = (String)ScriptBytecodeAdapter.asType((Object)credsStoreNode, String.class);
            return this.runCredentialProvider(repository, credsStore);
        }
        log.debug("No helper found in the {} section", (Object)CREDS_STORE_SECTION);
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private static String runCommand(String hostName, String credentialHelperName) {
        Reference hostName2 = new Reference((Object)hostName);
        log.debug("Executing docker credential helper: {} to locate auth config for: {}", (Object)credentialHelperName, (Object)((String)hostName2.get()));
        StringBuilder sOut = new StringBuilder();
        StringBuilder sErr = new StringBuilder();
        Process proc = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credentialHelperName}, new String[]{"", " get"})));
        public final class _runCommand_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference hostName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _runCommand_closure1(Object _outerInstance, Object _thisObject, Reference hostName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.hostName = reference = hostName;
            }

            public Object doCall(Writer writer) {
                return IOGroovyMethods.leftShift((Writer)writer, (Object)this.hostName.get());
            }

            public Object call(Writer writer) {
                return this.doCall(writer);
            }

            public String getHostName() {
                return ShortTypeHandling.castToString((Object)this.hostName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _runCommand_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ProcessGroovyMethods.withWriter((Process)proc, (Closure)new _runCommand_closure1(RegistryAuthLocator.class, RegistryAuthLocator.class, hostName2));
        proc.waitFor();
        ProcessGroovyMethods.waitForProcessOutput((Process)proc, (Appendable)sOut, (Appendable)sErr);
        if (sErr.length() > 0) {
            log.error("{} get: {}", (Object)credentialHelperName, (Object)sErr.toString());
        }
        String string = sOut.toString();
        try {
            return string;
        }
        catch (Exception e) {
            log.error("Failure running docker credential helper ({})", (Object)credentialHelperName);
            throw (Throwable)e;
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RegistryAuthLocator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = Logging.getLogger(RegistryAuthLocator.class);
    }
}

