/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks;

import com.bmuschko.gradle.docker.DockerExtension;
import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.tasks.DockerClientConfiguration;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractDockerRemoteApiTask
extends DefaultTask
implements GroovyObject {
    @Input
    @Optional
    private final Property<String> url;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    private final DirectoryProperty certPath;
    @Input
    @Optional
    private final Property<String> apiVersion;
    private Action<? super Throwable> errorHandler;
    protected Action<? super Object> nextHandler;
    private Runnable completeHandler;
    private final Closure memoizedMethodClosure$getDockerClient;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AbstractDockerRemoteApiTask() {
        MetaClass metaClass;
        Closure closure;
        Property property;
        DirectoryProperty directoryProperty;
        Property property2;
        this.url = property2 = ((ProjectInternal)this.getProject()).getObjects().property(String.class);
        this.certPath = directoryProperty = ((ProjectInternal)this.getProject()).getObjects().directoryProperty();
        this.apiVersion = property = ((ProjectInternal)this.getProject()).getObjects().property(String.class);
        this.memoizedMethodClosure$getDockerClient = closure = new _closure1((Object)this, (Object)this).memoize();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void start() {
        boolean commandFailed;
        block6: {
            commandFailed = false;
            try {
                this.runRemoteCommand();
            }
            catch (Exception possibleException) {
                boolean bl;
                commandFailed = bl = true;
                if (DefaultTypeTransformation.booleanUnbox(this.errorHandler)) {
                    this.errorHandler.execute((Object)possibleException);
                    break block6;
                }
                throw (Throwable)possibleException;
            }
        }
        if (!commandFailed && DefaultTypeTransformation.booleanUnbox((Object)this.completeHandler)) {
            this.completeHandler.run();
        }
    }

    public void onError(Action<? super Throwable> action) {
        Action<? super Throwable> action2 = action;
        this.errorHandler = action2;
    }

    public void onNext(Action<? super Object> action) {
        Action<? super Object> action2 = action;
        this.nextHandler = action2;
    }

    public void onComplete(Runnable callback) {
        Runnable runnable;
        this.completeHandler = runnable = callback;
    }

    @org.gradle.api.tasks.Internal
    public DockerClient getDockerClient() {
        return (DockerClient)ScriptBytecodeAdapter.castToType((Object)this.memoizedMethodClosure$getDockerClient.call(), DockerClient.class);
    }

    private DockerCmdExecFactory getDockerCmdExecFactory() {
        Boolean bl;
        Object object = this.getProject().findProperty("gdpNettyExecFactory");
        Boolean bl2 = Boolean.valueOf(object != null ? DefaultGroovyMethods.toString((Object)object) : null);
        boolean useNettyExecFactory = DefaultTypeTransformation.booleanUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)bl2) ? bl2 : (DefaultTypeTransformation.booleanUnbox((Object)(bl = Boolean.valueOf(System.getProperty("gdp.netty.exec.factory")))) ? bl : Boolean.valueOf(System.getenv("GDP_NETTY_EXEC_FACTORY")))));
        if (useNettyExecFactory) {
            this.getLogger().debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Using ", (CharSequence)NettyDockerCmdExecFactory.class.getSimpleName()), (CharSequence)" as driver for "), (CharSequence)DockerClient.class.getSimpleName()));
        }
        return (DockerCmdExecFactory)ScriptBytecodeAdapter.castToType((Object)(useNettyExecFactory ? new NettyDockerCmdExecFactory() : null), DockerCmdExecFactory.class);
    }

    private DockerClientConfiguration createDockerClientConfig() {
        DockerClientConfiguration dockerClientConfig = new DockerClientConfiguration();
        Object object = this.url.getOrNull();
        dockerClientConfig.setUrl(ShortTypeHandling.castToString((Object)object));
        Object object2 = this.certPath.getOrNull();
        dockerClientConfig.setCertPath((Directory)ScriptBytecodeAdapter.castToType((Object)object2, Directory.class));
        Object object3 = this.apiVersion.getOrNull();
        dockerClientConfig.setApiVersion(ShortTypeHandling.castToString((Object)object3));
        return dockerClientConfig;
    }

    private String getDockerHostUrl(DockerClientConfiguration dockerClientConfiguration, DockerExtension dockerExtension) {
        String string = dockerClientConfiguration.getUrl();
        String url = (DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ShortTypeHandling.castToString((Object)dockerExtension.getUrl().getOrNull())).toLowerCase();
        return url.startsWith("http") ? StringGroovyMethods.plus((String)"tcp", (CharSequence)url.substring(url.indexOf(":"))) : url;
    }

    public abstract void runRemoteCommand();

    @org.gradle.api.tasks.Internal
    @Generated
    protected DockerClient memoizedMethodPriv$getDockerClient() {
        Object object;
        DockerClientConfiguration dockerClientConfiguration = this.createDockerClientConfig();
        DockerExtension dockerExtension = (DockerExtension)ScriptBytecodeAdapter.castToType((Object)((ProjectInternal)this.getProject()).getExtensions().getByName(DockerRemoteApiPlugin.EXTENSION_NAME), DockerExtension.class);
        String dockerUrl = this.getDockerHostUrl(dockerClientConfiguration, dockerExtension);
        Directory directory = dockerClientConfiguration.getCertPath();
        File file = directory != null ? directory.getAsFile() : null;
        File dockerCertPath = DefaultTypeTransformation.booleanUnbox((Object)file) ? file : ((object = dockerExtension.getCertPath().getOrNull()) != null ? ((Directory)object).getAsFile() : null);
        String string = dockerClientConfiguration.getApiVersion();
        String apiVersion = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ShortTypeHandling.castToString((Object)dockerExtension.getApiVersion().getOrNull());
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        dockerClientConfigBuilder.withDockerHost(dockerUrl);
        if (DefaultTypeTransformation.booleanUnbox((Object)dockerCertPath)) {
            dockerClientConfigBuilder.withDockerTlsVerify(true);
            dockerClientConfigBuilder.withDockerCertPath(dockerCertPath.getCanonicalPath());
        } else {
            dockerClientConfigBuilder.withDockerTlsVerify(false);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)apiVersion)) {
            dockerClientConfigBuilder.withApiVersion(apiVersion);
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        Reference dockerClient = new Reference((Object)DockerClientBuilder.getInstance(dockerClientConfig).withDockerCmdExecFactory(this.getDockerCmdExecFactory()).build());
        public final class _memoizedMethodPriv_getDockerClient_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dockerClient;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _memoizedMethodPriv_getDockerClient_closure2(Object _outerInstance, Object _thisObject, Reference dockerClient) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dockerClient = reference = dockerClient;
            }

            public Object doCall(Object it) {
                ((DockerClient)this.dockerClient.get()).close();
                return null;
            }

            public DockerClient getDockerClient() {
                return (DockerClient)ScriptBytecodeAdapter.castToType((Object)this.dockerClient.get(), DockerClient.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _memoizedMethodPriv_getDockerClient_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((ProjectInternal)this.getProject()).getGradle().buildFinished((Closure)new _memoizedMethodPriv_getDockerClient_closure2((Object)this, (Object)this, dockerClient));
        return (DockerClient)dockerClient.get();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractDockerRemoteApiTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public final Property<String> getUrl() {
        return this.url;
    }

    @Generated
    public final DirectoryProperty getCertPath() {
        return this.certPath;
    }

    @Generated
    public final Property<String> getApiVersion() {
        return this.apiVersion;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractDockerRemoteApiTask)((Object)this.getThisObject()))), (String)"memoizedMethodPriv$getDockerClient", (Object)new Object[0]);
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

