/*
 * Decompiled with CFR 0.152.
 */
package bathe;

import bathe.BatheInitializer;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;

public class BatheInitializerProcessor {
    public static final String BATHE_INITIALIZER_DISABLE = "bathe.disable.";
    protected Set<BatheInitializer> initializers = new TreeSet<BatheInitializer>(new Comparator<BatheInitializer>(){

        @Override
        public int compare(BatheInitializer o1, BatheInitializer o2) {
            int orderCompare = Integer.compare(o1.getOrder(), o2.getOrder());
            if (orderCompare == 0) {
                orderCompare = o1.getName().compareTo(o2.getName());
            }
            return orderCompare;
        }
    });

    protected void collectInitializers(ClassLoader loader) {
        ServiceLoader<BatheInitializer> services = ServiceLoader.load(BatheInitializer.class, loader);
        for (BatheInitializer initializer : services) {
            this.initializers.add(initializer);
        }
    }

    public String[] process(String[] args, String jumpClass, ClassLoader loader) {
        this.collectInitializers(loader == null ? Thread.currentThread().getContextClassLoader() : loader);
        for (BatheInitializer initializer : this.initializers) {
            if (System.getProperty(BATHE_INITIALIZER_DISABLE + initializer.getName()) != null) continue;
            args = initializer.initialize(args, jumpClass);
        }
        return args;
    }
}

