/*
 * Decompiled with CFR 0.152.
 */
package bathe;

import bathe.BatheInitializerProcessor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class BatheBooter {
    protected static final String BATHE_EXTERNAL_CLASSPATH = "bathe.externalClassPath";
    private static final String MAIN_OVERRIDE = "-R";
    private static final String JUMP_CLASS = "Jump-Class";
    private static final String BATHE_IMPLEMENTATION_VERSION = "Bathe-Implementation-Version";
    protected String runnerClass;
    protected File jar;
    protected String[] passingArgs;

    public static void main(String[] args) throws IOException {
        new BatheBooter().run(args);
    }

    protected void parseCommandLine(String[] args) {
        ArrayList<String> appArguments = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith(MAIN_OVERRIDE)) {
                this.runnerClass = arg.substring(MAIN_OVERRIDE.length());
                continue;
            }
            appArguments.add(arg);
        }
        if (this.runnerClass == null) {
            this.attemptToGetJumpClassFromManifest();
        }
        if (appArguments.size() > 0 && this.runnerClass == null) {
            System.err.println("Usage: java -jar " + this.jar.getName() + " [options]\n\nArguments:\n  " + MAIN_OVERRIDE + "<class-name>      specify the main class.\n  \nSpecify Jump-Class: in your /META-INF/MANIFEST.MF to automatically define a class to run");
            System.exit(-2);
        }
        this.passingArgs = new String[appArguments.size()];
        appArguments.toArray(this.passingArgs);
    }

    protected void attemptToGetJumpClassFromManifest() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attr = manifest.getMainAttributes();
                String jumpGate = attr.getValue(JUMP_CLASS);
                if (jumpGate == null) continue;
                this.runnerClass = jumpGate;
                System.setProperty(BATHE_IMPLEMENTATION_VERSION, attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run(String[] args) throws IOException {
        this.jar = this.getRunFile();
        this.parseCommandLine(args);
        String externalClasspath = System.getProperty(BATHE_EXTERNAL_CLASSPATH);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (externalClasspath != null) {
            classLoader = new URLClassLoader(new URL[]{new File(externalClasspath).toURI().toURL()}, classLoader);
        }
        this.runWithLoader(classLoader, this.jar, this.runnerClass, this.passingArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithLoader(ClassLoader loader, File runnable, String runnerClass, String[] args) {
        ClassLoader localLoader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        try {
            args = new BatheInitializerProcessor().process(args, runnerClass, localLoader);
            this.exec(localLoader, runnable, runnerClass, args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    private boolean tryRunMethod(Class<?> runner, File runnable, String[] args) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = runner.getMethod("run", File.class, String[].class);
            method.invoke(null, runnable, args);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private boolean tryMainMethod(Class<?> runner, String[] args) throws InvocationTargetException, IllegalAccessException {
        try {
            Method method = runner.getMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public void exec(ClassLoader loader, File runnable, String runnerClass, String[] args) {
        try {
            Class<?> runner = Class.forName(runnerClass, true, loader);
            if (!this.tryRunMethod(runner, runnable, args) && !this.tryMainMethod(runner, args)) {
                throw new RuntimeException("Cannot find run or main method in " + runnerClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class you are trying to run can not be found on the classpath: " + runnerClass + ", " + loader.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Run method needs to be public and static", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Unhandled exception in WebApp runner", e);
        }
    }

    protected File getRunFile() {
        URL jarUrl = BatheBooter.class.getProtectionDomain().getCodeSource().getLocation();
        return this.resolveJarFile(jarUrl);
    }

    protected File resolveJarFile(URL classPathUrl) {
        try {
            URI jarUri = classPathUrl.toURI();
            if (jarUri.getScheme().matches("^[jw]ar$")) {
                String strippedUri = jarUri.getRawSchemeSpecificPart().replaceAll("!.+$", "");
                jarUri = new URI(strippedUri);
            }
            return new File(jarUri);
        }
        catch (IllegalArgumentException | URISyntaxException error) {
            throw new RuntimeException("Cannot get the runnable artifact file from " + classPathUrl.toString(), error);
        }
    }
}

