/*
 * Decompiled with CFR 0.152.
 */
package com.blueconic.browscap;

import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.impl.UserAgentFileParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UserAgentService {
    public static final int BUNDLED_BROWSCAP_VERSION = 6000043;
    private String myZipFilePath;
    private InputStream myZipFileStream;

    public UserAgentService() {
    }

    public UserAgentService(String zipFilePath) {
        this.myZipFilePath = zipFilePath;
    }

    public UserAgentService(InputStream zipFileStream) {
        this.myZipFileStream = zipFileStream;
    }

    public UserAgentParser loadParser() throws IOException, ParseException {
        Set<BrowsCapField> defaultFields = Stream.of(BrowsCapField.values()).filter(BrowsCapField::isDefault).collect(Collectors.toSet());
        return this.createParserWithFields(defaultFields);
    }

    public UserAgentParser loadParser(Collection<BrowsCapField> fields) throws IOException, ParseException {
        return this.createParserWithFields(fields);
    }

    private UserAgentParser createParserWithFields(Collection<BrowsCapField> fields) throws IOException, ParseException {
        Throwable throwable = null;
        try (InputStream zipStream = this.getCsvFileStream();){
            Throwable throwable2;
            ZipInputStream zipIn;
            block26: {
                UserAgentParser userAgentParser;
                block27: {
                    block28: {
                        zipIn = new ZipInputStream(zipStream);
                        throwable2 = null;
                        ZipEntry entry = null;
                        while ((entry = zipIn.getNextEntry()) != null && !entry.getName().endsWith(".csv")) {
                        }
                        if (entry == null || entry.isDirectory()) break block26;
                        userAgentParser = UserAgentFileParser.parse(new InputStreamReader((InputStream)zipIn, StandardCharsets.UTF_8), fields);
                        if (zipIn == null) break block27;
                        if (throwable2 == null) break block28;
                        try {
                            zipIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    zipIn.close();
                }
                return userAgentParser;
            }
            try {
                try {
                    try {
                        throw new IOException("Unable to find the BrowsCap CSV file in the ZIP file");
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (zipIn != null) {
                        if (throwable2 != null) {
                            try {
                                zipIn.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            zipIn.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public static String getBundledCsvFileName() {
        return "browscap-6000043.zip";
    }

    private InputStream getCsvFileStream() throws FileNotFoundException {
        if (this.myZipFileStream == null) {
            if (this.myZipFilePath == null) {
                String csvFileName = UserAgentService.getBundledCsvFileName();
                return this.getClass().getClassLoader().getResourceAsStream(csvFileName);
            }
            return new FileInputStream(this.myZipFilePath);
        }
        return this.myZipFileStream;
    }
}

