/*
 * Decompiled with CFR 0.152.
 */
package com.blueconic.browscap.impl;

import com.blueconic.browscap.impl.Literal;
import java.util.BitSet;

class SearchableString {
    private static final int[] EMPTY = new int[0];
    private static final int[][] SINGLE_VALUES = SearchableString.getSingleValues();
    private final char[] myChars;
    private final int[][] myIndices;
    private final Cache myPrefixCache = new Cache();
    private final Cache myPostfixCache = new Cache();
    private final int[] myBuffer;

    SearchableString(String stringValue) {
        this.myChars = stringValue.toCharArray();
        int max = Literal.getNumberOfInstances() + 1;
        this.myIndices = new int[max][];
        this.myBuffer = new int[this.myChars.length];
    }

    int getSize() {
        return this.myChars.length;
    }

    boolean startsWith(Literal literal) {
        int index = literal.getIndex();
        Boolean cached = this.myPrefixCache.get(index);
        if (cached != null) {
            return cached;
        }
        boolean result = literal.matches(this.myChars, 0);
        this.myPrefixCache.set(index, result);
        return result;
    }

    boolean endsWith(Literal literal) {
        int index = literal.getIndex();
        Boolean cached = this.myPostfixCache.get(index);
        if (cached != null) {
            return cached;
        }
        boolean result = literal.matches(this.myChars, this.myChars.length - literal.getLength());
        this.myPostfixCache.set(index, result);
        return result;
    }

    int[] getIndices(Literal literal) {
        int index = literal.getIndex();
        int[] cached = this.myIndices[index];
        if (cached != null) {
            return cached;
        }
        int[] values = this.findIndices(literal);
        this.myIndices[index] = values;
        return values;
    }

    private int[] findIndices(Literal literal) {
        int count = 0;
        char s = literal.getFirstChar();
        for (int i = 0; i < this.myChars.length; ++i) {
            if (this.myChars[i] != s && s != '?' || !literal.matches(this.myChars, i)) continue;
            this.myBuffer[count] = i;
            ++count;
        }
        if (count == 0) {
            return EMPTY;
        }
        if (count == 1 && this.myBuffer[0] < SINGLE_VALUES.length) {
            int index = this.myBuffer[0];
            return SINGLE_VALUES[index];
        }
        int[] values = new int[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.myBuffer[i];
        }
        return values;
    }

    public String toString() {
        return new String(this.myChars);
    }

    private static final int[][] getSingleValues() {
        int[][] result = new int[1024][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new int[]{i};
        }
        return result;
    }

    static class Cache {
        private final BitSet myValues = new BitSet();
        private final BitSet myIsKnown = new BitSet();

        Cache() {
        }

        Boolean get(int index) {
            if (this.myValues.get(index)) {
                return Boolean.TRUE;
            }
            if (this.myIsKnown.get(index)) {
                return Boolean.FALSE;
            }
            return null;
        }

        void set(int index, boolean flag) {
            this.myValues.set(index, flag);
            this.myIsKnown.set(index, true);
        }
    }
}

