/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.mydailyjava.weaklockfree;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class WeakConcurrentMap<K, V>
extends ReferenceQueue<K>
implements Runnable {
    private static final AtomicLong ID = new AtomicLong();
    final ConcurrentMap<WeakKey<K>, V> target = new ConcurrentHashMap<WeakKey<K>, V>();
    private final Thread thread;

    public WeakConcurrentMap(boolean cleanerThread) {
        if (cleanerThread) {
            this.thread = new Thread(this);
            this.thread.setName("weak-ref-cleaner-" + ID.getAndIncrement());
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object value = this.target.get(new WeakKey<K>(key));
        if (value == null && (value = this.defaultValue(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    public void put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        this.target.put(new WeakKey<K>(key, this), value);
    }

    public void remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.target.remove(new WeakKey<K>(key));
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K key) {
        return null;
    }

    public Thread getCleanerThread() {
        return this.thread;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.target.remove(this.remove());
            }
        }
        catch (InterruptedException ignored) {
            this.clear();
            return;
        }
    }

    public static class WithInlinedExpunction<K, V>
    extends WeakConcurrentMap<K, V> {
        public WithInlinedExpunction() {
            super(false);
        }

        @Override
        public V get(K key) {
            this.expungeStaleEntries();
            return super.get(key);
        }

        @Override
        public void put(K key, V value) {
            this.expungeStaleEntries();
            super.put(key, value);
        }

        @Override
        public void remove(K key) {
            this.expungeStaleEntries();
            super.remove(key);
        }

        void expungeStaleEntries() {
            Reference reference;
            while ((reference = this.poll()) != null) {
                this.target.remove(reference);
            }
        }
    }

    private static class WeakKey<T>
    extends WeakReference<T> {
        private final int hashCode;

        WeakKey(T key) {
            super(key);
            this.hashCode = System.identityHashCode(key);
        }

        WeakKey(T key, ReferenceQueue<? super T> queue) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return ((WeakKey)other).get() == this.get();
        }
    }
}

