/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.mydailyjava.weaklockfree;

import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;

public class DetachedThreadLocal<T>
implements Runnable {
    final WeakConcurrentMap<Thread, T> map;

    public DetachedThreadLocal(Cleaner cleaner) {
        switch (cleaner) {
            case THREAD: 
            case MANUAL: {
                this.map = new WeakConcurrentMap<Thread, T>(cleaner == Cleaner.THREAD){

                    @Override
                    protected T defaultValue(Thread key) {
                        return DetachedThreadLocal.this.initialValue(key);
                    }
                };
                break;
            }
            case INLINE: {
                this.map = new WeakConcurrentMap.WithInlinedExpunction<Thread, T>(){

                    @Override
                    protected T defaultValue(Thread key) {
                        return DetachedThreadLocal.this.initialValue(key);
                    }
                };
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public T get() {
        return this.map.get(Thread.currentThread());
    }

    public void set(T value) {
        this.map.put(Thread.currentThread(), value);
    }

    public void clear() {
        this.map.remove(Thread.currentThread());
    }

    public void clearAll() {
        this.map.clear();
    }

    public void inherit(Thread thread) {
        this.map.put(thread, this.get());
    }

    protected T initialValue(Thread thread) {
        return null;
    }

    public Thread getCleanerThread() {
        return this.map.getCleanerThread();
    }

    @Override
    public void run() {
        this.map.run();
    }

    public static enum Cleaner {
        THREAD,
        INLINE,
        MANUAL;

    }
}

