/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="scheduler")
public class SchedulerProperties {
    private Map<String, SchedulerItemProperties> configs = new HashMap<String, SchedulerItemProperties>();

    public Map<String, SchedulerItemProperties> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, SchedulerItemProperties> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerProperties)) {
            return false;
        }
        SchedulerProperties other = (SchedulerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, SchedulerItemProperties> this$configs = this.getConfigs();
        Map<String, SchedulerItemProperties> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, SchedulerItemProperties> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "SchedulerProperties(configs=" + this.getConfigs() + ")";
    }

    public static enum SchedulerType {
        ELASTIC,
        PARALLEL,
        SINGLE,
        IMMEDIATE,
        NEW_ELASTIC,
        NEW_PARALLEL,
        NEW_SINGLE,
        EXECUTOR,
        THREAD_POOL;

    }

    public static enum QueueType {
        ARRAY,
        LINKED;

    }

    public static class SchedulerThreadPoolProperties {
        private Integer corePoolSize = 10;
        private Boolean allowCoreThreadTimeOut = false;
        private Integer maximumPoolSize = 50;
        private Integer ttlSeconds = 60;
        private QueueType queueType = QueueType.LINKED;
        private Integer queueSize = Integer.MAX_VALUE;

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Boolean getAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public Integer getTtlSeconds() {
            return this.ttlSeconds;
        }

        public QueueType getQueueType() {
            return this.queueType;
        }

        public Integer getQueueSize() {
            return this.queueSize;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setTtlSeconds(Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
        }

        public void setQueueType(QueueType queueType) {
            this.queueType = queueType;
        }

        public void setQueueSize(Integer queueSize) {
            this.queueSize = queueSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerThreadPoolProperties)) {
                return false;
            }
            SchedulerThreadPoolProperties other = (SchedulerThreadPoolProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$corePoolSize = this.getCorePoolSize();
            Integer other$corePoolSize = other.getCorePoolSize();
            if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
                return false;
            }
            Boolean this$allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            Boolean other$allowCoreThreadTimeOut = other.getAllowCoreThreadTimeOut();
            if (this$allowCoreThreadTimeOut == null ? other$allowCoreThreadTimeOut != null : !((Object)this$allowCoreThreadTimeOut).equals(other$allowCoreThreadTimeOut)) {
                return false;
            }
            Integer this$maximumPoolSize = this.getMaximumPoolSize();
            Integer other$maximumPoolSize = other.getMaximumPoolSize();
            if (this$maximumPoolSize == null ? other$maximumPoolSize != null : !((Object)this$maximumPoolSize).equals(other$maximumPoolSize)) {
                return false;
            }
            Integer this$ttlSeconds = this.getTtlSeconds();
            Integer other$ttlSeconds = other.getTtlSeconds();
            if (this$ttlSeconds == null ? other$ttlSeconds != null : !((Object)this$ttlSeconds).equals(other$ttlSeconds)) {
                return false;
            }
            QueueType this$queueType = this.getQueueType();
            QueueType other$queueType = other.getQueueType();
            if (this$queueType == null ? other$queueType != null : !((Object)((Object)this$queueType)).equals((Object)other$queueType)) {
                return false;
            }
            Integer this$queueSize = this.getQueueSize();
            Integer other$queueSize = other.getQueueSize();
            return !(this$queueSize == null ? other$queueSize != null : !((Object)this$queueSize).equals(other$queueSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerThreadPoolProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $corePoolSize = this.getCorePoolSize();
            result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
            Boolean $allowCoreThreadTimeOut = this.getAllowCoreThreadTimeOut();
            result = result * 59 + ($allowCoreThreadTimeOut == null ? 43 : ((Object)$allowCoreThreadTimeOut).hashCode());
            Integer $maximumPoolSize = this.getMaximumPoolSize();
            result = result * 59 + ($maximumPoolSize == null ? 43 : ((Object)$maximumPoolSize).hashCode());
            Integer $ttlSeconds = this.getTtlSeconds();
            result = result * 59 + ($ttlSeconds == null ? 43 : ((Object)$ttlSeconds).hashCode());
            QueueType $queueType = this.getQueueType();
            result = result * 59 + ($queueType == null ? 43 : ((Object)((Object)$queueType)).hashCode());
            Integer $queueSize = this.getQueueSize();
            result = result * 59 + ($queueSize == null ? 43 : ((Object)$queueSize).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerThreadPoolProperties(corePoolSize=" + this.getCorePoolSize() + ", allowCoreThreadTimeOut=" + this.getAllowCoreThreadTimeOut() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", ttlSeconds=" + this.getTtlSeconds() + ", queueType=" + (Object)((Object)this.getQueueType()) + ", queueSize=" + this.getQueueSize() + ")";
        }
    }

    public static enum ExecutorType {
        FIXED_THREAD_POOL,
        WORK_STEALING_POOL,
        SINGLE_THREAD_POOL,
        CACHED_THREAD_POOL;

    }

    public static class SchedulerExecutorProperties {
        private ExecutorType type = ExecutorType.CACHED_THREAD_POOL;
        private Integer numberOfThread;
        private Integer parallelism = Runtime.getRuntime().availableProcessors();

        public ExecutorType getType() {
            return this.type;
        }

        public Integer getNumberOfThread() {
            return this.numberOfThread;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }

        public void setType(ExecutorType type) {
            this.type = type;
        }

        public void setNumberOfThread(Integer numberOfThread) {
            this.numberOfThread = numberOfThread;
        }

        public void setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerExecutorProperties)) {
                return false;
            }
            SchedulerExecutorProperties other = (SchedulerExecutorProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExecutorType this$type = this.getType();
            ExecutorType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Integer this$numberOfThread = this.getNumberOfThread();
            Integer other$numberOfThread = other.getNumberOfThread();
            if (this$numberOfThread == null ? other$numberOfThread != null : !((Object)this$numberOfThread).equals(other$numberOfThread)) {
                return false;
            }
            Integer this$parallelism = this.getParallelism();
            Integer other$parallelism = other.getParallelism();
            return !(this$parallelism == null ? other$parallelism != null : !((Object)this$parallelism).equals(other$parallelism));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerExecutorProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutorType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Integer $numberOfThread = this.getNumberOfThread();
            result = result * 59 + ($numberOfThread == null ? 43 : ((Object)$numberOfThread).hashCode());
            Integer $parallelism = this.getParallelism();
            result = result * 59 + ($parallelism == null ? 43 : ((Object)$parallelism).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerExecutorProperties(type=" + (Object)((Object)this.getType()) + ", numberOfThread=" + this.getNumberOfThread() + ", parallelism=" + this.getParallelism() + ")";
        }
    }

    public static class SchedulerNewSingleProperties {
        private String name;
        private Boolean daemon = false;

        public String getName() {
            return this.name;
        }

        public Boolean getDaemon() {
            return this.daemon;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDaemon(Boolean daemon) {
            this.daemon = daemon;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerNewSingleProperties)) {
                return false;
            }
            SchedulerNewSingleProperties other = (SchedulerNewSingleProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Boolean this$daemon = this.getDaemon();
            Boolean other$daemon = other.getDaemon();
            return !(this$daemon == null ? other$daemon != null : !((Object)this$daemon).equals(other$daemon));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerNewSingleProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Boolean $daemon = this.getDaemon();
            result = result * 59 + ($daemon == null ? 43 : ((Object)$daemon).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerNewSingleProperties(name=" + this.getName() + ", daemon=" + this.getDaemon() + ")";
        }
    }

    public static class SchedulerNewParallelProperties {
        private String name;
        private Integer parallelism = Optional.ofNullable(System.getProperty("reactor.schedulers.defaultPoolSize")).map(Integer::parseInt).orElseGet(() -> Runtime.getRuntime().availableProcessors());
        private Boolean daemon = false;

        public String getName() {
            return this.name;
        }

        public Integer getParallelism() {
            return this.parallelism;
        }

        public Boolean getDaemon() {
            return this.daemon;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
        }

        public void setDaemon(Boolean daemon) {
            this.daemon = daemon;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerNewParallelProperties)) {
                return false;
            }
            SchedulerNewParallelProperties other = (SchedulerNewParallelProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$parallelism = this.getParallelism();
            Integer other$parallelism = other.getParallelism();
            if (this$parallelism == null ? other$parallelism != null : !((Object)this$parallelism).equals(other$parallelism)) {
                return false;
            }
            Boolean this$daemon = this.getDaemon();
            Boolean other$daemon = other.getDaemon();
            return !(this$daemon == null ? other$daemon != null : !((Object)this$daemon).equals(other$daemon));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerNewParallelProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $parallelism = this.getParallelism();
            result = result * 59 + ($parallelism == null ? 43 : ((Object)$parallelism).hashCode());
            Boolean $daemon = this.getDaemon();
            result = result * 59 + ($daemon == null ? 43 : ((Object)$daemon).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerNewParallelProperties(name=" + this.getName() + ", parallelism=" + this.getParallelism() + ", daemon=" + this.getDaemon() + ")";
        }
    }

    public static class SchedulerNewElasticProperties {
        private String name;
        private Integer ttlSeconds = 60;
        private Boolean daemon = false;

        public String getName() {
            return this.name;
        }

        public Integer getTtlSeconds() {
            return this.ttlSeconds;
        }

        public Boolean getDaemon() {
            return this.daemon;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTtlSeconds(Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
        }

        public void setDaemon(Boolean daemon) {
            this.daemon = daemon;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerNewElasticProperties)) {
                return false;
            }
            SchedulerNewElasticProperties other = (SchedulerNewElasticProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$ttlSeconds = this.getTtlSeconds();
            Integer other$ttlSeconds = other.getTtlSeconds();
            if (this$ttlSeconds == null ? other$ttlSeconds != null : !((Object)this$ttlSeconds).equals(other$ttlSeconds)) {
                return false;
            }
            Boolean this$daemon = this.getDaemon();
            Boolean other$daemon = other.getDaemon();
            return !(this$daemon == null ? other$daemon != null : !((Object)this$daemon).equals(other$daemon));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerNewElasticProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $ttlSeconds = this.getTtlSeconds();
            result = result * 59 + ($ttlSeconds == null ? 43 : ((Object)$ttlSeconds).hashCode());
            Boolean $daemon = this.getDaemon();
            result = result * 59 + ($daemon == null ? 43 : ((Object)$daemon).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerNewElasticProperties(name=" + this.getName() + ", ttlSeconds=" + this.getTtlSeconds() + ", daemon=" + this.getDaemon() + ")";
        }
    }

    public static class SchedulerItemProperties {
        private SchedulerType type = SchedulerType.IMMEDIATE;
        private SchedulerNewElasticProperties newElastic = new SchedulerNewElasticProperties();
        private SchedulerNewParallelProperties newParallel = new SchedulerNewParallelProperties();
        private SchedulerNewSingleProperties newSingle = new SchedulerNewSingleProperties();
        private SchedulerExecutorProperties executor = new SchedulerExecutorProperties();
        private SchedulerThreadPoolProperties threadPool = new SchedulerThreadPoolProperties();

        public SchedulerType getType() {
            return this.type;
        }

        public SchedulerNewElasticProperties getNewElastic() {
            return this.newElastic;
        }

        public SchedulerNewParallelProperties getNewParallel() {
            return this.newParallel;
        }

        public SchedulerNewSingleProperties getNewSingle() {
            return this.newSingle;
        }

        public SchedulerExecutorProperties getExecutor() {
            return this.executor;
        }

        public SchedulerThreadPoolProperties getThreadPool() {
            return this.threadPool;
        }

        public void setType(SchedulerType type) {
            this.type = type;
        }

        public void setNewElastic(SchedulerNewElasticProperties newElastic) {
            this.newElastic = newElastic;
        }

        public void setNewParallel(SchedulerNewParallelProperties newParallel) {
            this.newParallel = newParallel;
        }

        public void setNewSingle(SchedulerNewSingleProperties newSingle) {
            this.newSingle = newSingle;
        }

        public void setExecutor(SchedulerExecutorProperties executor) {
            this.executor = executor;
        }

        public void setThreadPool(SchedulerThreadPoolProperties threadPool) {
            this.threadPool = threadPool;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchedulerItemProperties)) {
                return false;
            }
            SchedulerItemProperties other = (SchedulerItemProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchedulerType this$type = this.getType();
            SchedulerType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            SchedulerNewElasticProperties this$newElastic = this.getNewElastic();
            SchedulerNewElasticProperties other$newElastic = other.getNewElastic();
            if (this$newElastic == null ? other$newElastic != null : !((Object)this$newElastic).equals(other$newElastic)) {
                return false;
            }
            SchedulerNewParallelProperties this$newParallel = this.getNewParallel();
            SchedulerNewParallelProperties other$newParallel = other.getNewParallel();
            if (this$newParallel == null ? other$newParallel != null : !((Object)this$newParallel).equals(other$newParallel)) {
                return false;
            }
            SchedulerNewSingleProperties this$newSingle = this.getNewSingle();
            SchedulerNewSingleProperties other$newSingle = other.getNewSingle();
            if (this$newSingle == null ? other$newSingle != null : !((Object)this$newSingle).equals(other$newSingle)) {
                return false;
            }
            SchedulerExecutorProperties this$executor = this.getExecutor();
            SchedulerExecutorProperties other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !((Object)this$executor).equals(other$executor)) {
                return false;
            }
            SchedulerThreadPoolProperties this$threadPool = this.getThreadPool();
            SchedulerThreadPoolProperties other$threadPool = other.getThreadPool();
            return !(this$threadPool == null ? other$threadPool != null : !((Object)this$threadPool).equals(other$threadPool));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SchedulerItemProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchedulerType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            SchedulerNewElasticProperties $newElastic = this.getNewElastic();
            result = result * 59 + ($newElastic == null ? 43 : ((Object)$newElastic).hashCode());
            SchedulerNewParallelProperties $newParallel = this.getNewParallel();
            result = result * 59 + ($newParallel == null ? 43 : ((Object)$newParallel).hashCode());
            SchedulerNewSingleProperties $newSingle = this.getNewSingle();
            result = result * 59 + ($newSingle == null ? 43 : ((Object)$newSingle).hashCode());
            SchedulerExecutorProperties $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : ((Object)$executor).hashCode());
            SchedulerThreadPoolProperties $threadPool = this.getThreadPool();
            result = result * 59 + ($threadPool == null ? 43 : ((Object)$threadPool).hashCode());
            return result;
        }

        public String toString() {
            return "SchedulerProperties.SchedulerItemProperties(type=" + (Object)((Object)this.getType()) + ", newElastic=" + this.getNewElastic() + ", newParallel=" + this.getNewParallel() + ", newSingle=" + this.getNewSingle() + ", executor=" + this.getExecutor() + ", threadPool=" + this.getThreadPool() + ")";
        }
    }
}

