/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.cache;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.cache.CommandCache;
import com.blibli.oss.command.cache.CommandCacheMapper;
import com.blibli.oss.command.plugin.CommandInterceptor;
import reactor.core.publisher.Mono;

public class CommandCacheInterceptor
implements CommandInterceptor {
    private CommandCache commandCache;
    private CommandCacheMapper commandCacheMapper;

    public CommandCacheInterceptor(CommandCache commandCache, CommandCacheMapper commandCacheMapper) {
        this.commandCache = commandCache;
        this.commandCacheMapper = commandCacheMapper;
    }

    @Override
    public <R, T> Mono<T> beforeExecute(Command<R, T> command, R request) {
        return Mono.fromCallable(() -> command.cacheKey(request)).flatMap(key -> this.commandCache.get((String)key)).map(json -> this.commandCacheMapper.fromString((String)json, command.responseClass()));
    }

    @Override
    public <R, T> Mono<Void> afterSuccessExecute(Command<R, T> command, R request, T response) {
        return Mono.zip(this.evictCommandResponse(command, request), this.cacheCommandResponse(command, request, response)).flatMap(objects -> Mono.empty());
    }

    private <R, T> Mono<Boolean> cacheCommandResponse(Command<R, T> command, R request, T response) {
        return Mono.zip((Mono)Mono.fromCallable(() -> command.cacheKey(request)), (Mono)Mono.fromCallable(() -> this.commandCacheMapper.toString(response))).flatMap(tuple -> this.commandCache.cache((String)tuple.getT1(), (String)tuple.getT2())).switchIfEmpty(Mono.just((Object)false));
    }

    private <R, T> Mono<Long> evictCommandResponse(Command<R, T> command, R request) {
        return Mono.fromCallable(() -> command.evictKeys(request)).map(keys -> keys.toArray(new String[0])).flatMap(keys -> this.commandCache.evict((String)keys)).switchIfEmpty(Mono.just((Object)0L));
    }
}

