/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.plugin.impl;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.plugin.CommandKeyStrategy;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CommandKeyStrategyImpl
implements CommandKeyStrategy,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public String getCommandKey(Command<?, ?> command) {
        String key = command.key();
        if (key == null) {
            key = this.getBeanName(command);
        }
        if (key == null) {
            key = this.getClassName(command);
        }
        return key;
    }

    private String getClassName(Command<?, ?> command) {
        return command.getClass().getSimpleName();
    }

    private String getBeanName(Command<?, ?> command) {
        String[] names = this.applicationContext.getBeanNamesForType(command.getClass());
        if (names != null && names.length == 1) {
            return names[0];
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

