/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.impl;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.CommandBuilder;
import com.blibli.oss.command.CommandExecutor;
import com.blibli.oss.command.CommandProcessor;
import com.blibli.oss.command.exception.CommandValidationException;
import com.blibli.oss.command.helper.ErrorHelper;
import com.blibli.oss.command.impl.CommandBuilderImpl;
import com.blibli.oss.command.tuple.Tuple;
import com.blibli.oss.command.tuple.Tuple2;
import com.blibli.oss.command.tuple.Tuple3;
import com.blibli.oss.command.tuple.Tuple4;
import com.blibli.oss.command.tuple.Tuple5;
import java.util.Set;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import rx.Single;

public class CommandExecutorImpl
implements CommandExecutor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutorImpl.class);
    private Validator validator;
    private CommandProcessor commandProcessor;
    private ApplicationContext applicationContext;

    public CommandExecutorImpl(Validator validator, CommandProcessor commandProcessor) {
        this.validator = validator;
        this.commandProcessor = commandProcessor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public <R, T> CommandBuilder<R, T> build(Class<? extends Command<R, T>> commandClass, R request) {
        return new CommandBuilderImpl(request, commandClass);
    }

    @Override
    public <R, T> Single<T> execute(Class<? extends Command<R, T>> commandClass, R request) {
        return this.validateRequest(request, commandClass).flatMap(validRequest -> this.doExecute(commandClass, validRequest));
    }

    @Override
    public <R1, T1, R2, T2> Single<Tuple2<T1, T2>> executeAll(CommandBuilder<R1, T1> commandBuilder1, CommandBuilder<R2, T2> commandBuilder2) {
        return Single.zip(this.validateRequest(commandBuilder1.getRequest(), commandBuilder1.getCommandClass()), this.validateRequest(commandBuilder2.getRequest(), commandBuilder2.getCommandClass()), Tuple::of).flatMap(tuple -> Single.zip(this.doExecute(commandBuilder1.getCommandClass(), tuple.getFirst()), this.doExecute(commandBuilder2.getCommandClass(), tuple.getSecond()), Tuple2::new));
    }

    @Override
    public <R1, T1, R2, T2, R3, T3> Single<Tuple3<T1, T2, T3>> executeAll(CommandBuilder<R1, T1> commandBuilder1, CommandBuilder<R2, T2> commandBuilder2, CommandBuilder<R3, T3> commandBuilder3) {
        return Single.zip(this.validateRequest(commandBuilder1.getRequest(), commandBuilder1.getCommandClass()), this.validateRequest(commandBuilder2.getRequest(), commandBuilder2.getCommandClass()), this.validateRequest(commandBuilder3.getRequest(), commandBuilder3.getCommandClass()), Tuple::of).flatMap(tuple -> Single.zip(this.doExecute(commandBuilder1.getCommandClass(), tuple.getFirst()), this.doExecute(commandBuilder2.getCommandClass(), tuple.getSecond()), this.doExecute(commandBuilder3.getCommandClass(), tuple.getThird()), Tuple3::new));
    }

    @Override
    public <R1, T1, R2, T2, R3, T3, R4, T4> Single<Tuple4<T1, T2, T3, T4>> executeAll(CommandBuilder<R1, T1> commandBuilder1, CommandBuilder<R2, T2> commandBuilder2, CommandBuilder<R3, T3> commandBuilder3, CommandBuilder<R4, T4> commandBuilder4) {
        return Single.zip(this.validateRequest(commandBuilder1.getRequest(), commandBuilder1.getCommandClass()), this.validateRequest(commandBuilder2.getRequest(), commandBuilder2.getCommandClass()), this.validateRequest(commandBuilder3.getRequest(), commandBuilder3.getCommandClass()), this.validateRequest(commandBuilder4.getRequest(), commandBuilder4.getCommandClass()), Tuple::of).flatMap(tuple -> Single.zip(this.doExecute(commandBuilder1.getCommandClass(), tuple.getFirst()), this.doExecute(commandBuilder2.getCommandClass(), tuple.getSecond()), this.doExecute(commandBuilder3.getCommandClass(), tuple.getThird()), this.doExecute(commandBuilder4.getCommandClass(), tuple.getForth()), Tuple4::new));
    }

    @Override
    public <R1, T1, R2, T2, R3, T3, R4, T4, R5, T5> Single<Tuple5<T1, T2, T3, T4, T5>> executeAll(CommandBuilder<R1, T1> commandBuilder1, CommandBuilder<R2, T2> commandBuilder2, CommandBuilder<R3, T3> commandBuilder3, CommandBuilder<R4, T4> commandBuilder4, CommandBuilder<R5, T5> commandBuilder5) {
        return Single.zip(this.validateRequest(commandBuilder1.getRequest(), commandBuilder1.getCommandClass()), this.validateRequest(commandBuilder2.getRequest(), commandBuilder2.getCommandClass()), this.validateRequest(commandBuilder3.getRequest(), commandBuilder3.getCommandClass()), this.validateRequest(commandBuilder4.getRequest(), commandBuilder4.getCommandClass()), this.validateRequest(commandBuilder5.getRequest(), commandBuilder5.getCommandClass()), Tuple::of).flatMap(tuple -> Single.zip(this.doExecute(commandBuilder1.getCommandClass(), tuple.getFirst()), this.doExecute(commandBuilder2.getCommandClass(), tuple.getSecond()), this.doExecute(commandBuilder3.getCommandClass(), tuple.getThird()), this.doExecute(commandBuilder4.getCommandClass(), tuple.getForth()), this.doExecute(commandBuilder5.getCommandClass(), tuple.getFifth()), Tuple5::new));
    }

    @SafeVarargs
    private final <R> Single<R> validateRequest(R request, Class<? extends Command<?, ?>> ... classes) {
        return Single.create(singleSubscriber -> {
            try {
                if (this.isValidateRequest(classes)) {
                    log.info("Validate request {}", (Object)request.getClass().getName());
                    this.validateAndThrownIfInvalid(request);
                }
                singleSubscriber.onSuccess(request);
            }
            catch (Throwable throwable) {
                singleSubscriber.onError(throwable);
            }
        });
    }

    @SafeVarargs
    private final boolean isValidateRequest(Class<? extends Command<?, ?>> ... classes) {
        if (classes == null) {
            return false;
        }
        for (Class<Command<?, ?>> clazz : classes) {
            Command command = (Command)this.applicationContext.getBean(clazz);
            if (!command.validateRequest()) continue;
            return true;
        }
        return false;
    }

    private <R> void validateAndThrownIfInvalid(R request) throws CommandValidationException {
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            String validationMessage = ErrorHelper.from(constraintViolations).toString();
            log.warn("Invalid command request with validation message {}", (Object)validationMessage);
            throw new CommandValidationException(validationMessage, constraintViolations);
        }
    }

    private <R, T> Single<T> doExecute(Class<? extends Command<R, T>> commandClass, R request) {
        return this.commandProcessor.doExecute(commandClass, request);
    }

    @Override
    public <R, T1, T2> Single<Tuple2<T1, T2>> executeAll(Class<? extends Command<R, T1>> command1, Class<? extends Command<R, T2>> command2, R request) {
        return this.validateRequest(request, command1, command2).flatMap(validRequest -> Single.zip(this.doExecute(command1, request), this.doExecute(command2, request), Tuple::of));
    }

    @Override
    public <R, T1, T2, T3> Single<Tuple3<T1, T2, T3>> executeAll(Class<? extends Command<R, T1>> command1, Class<? extends Command<R, T2>> command2, Class<? extends Command<R, T3>> command3, R request) {
        return this.validateRequest(request, command1, command2, command3).flatMap(validRequest -> Single.zip(this.doExecute(command1, request), this.doExecute(command2, request), this.doExecute(command3, request), Tuple::of));
    }

    @Override
    public <R, T1, T2, T3, T4> Single<Tuple4<T1, T2, T3, T4>> executeAll(Class<? extends Command<R, T1>> command1, Class<? extends Command<R, T2>> command2, Class<? extends Command<R, T3>> command3, Class<? extends Command<R, T4>> command4, R request) {
        return this.validateRequest(request, command1, command2, command3, command4).flatMap(validRequest -> Single.zip(this.doExecute(command1, request), this.doExecute(command2, request), this.doExecute(command3, request), this.doExecute(command4, request), Tuple::of));
    }

    @Override
    public <R, T1, T2, T3, T4, T5> Single<Tuple5<T1, T2, T3, T4, T5>> executeAll(Class<? extends Command<R, T1>> command1, Class<? extends Command<R, T2>> command2, Class<? extends Command<R, T3>> command3, Class<? extends Command<R, T4>> command4, Class<? extends Command<R, T5>> command5, R request) {
        return this.validateRequest(request, command1, command2, command3, command4, command5).flatMap(validRequest -> Single.zip(this.doExecute(command1, request), this.doExecute(command2, request), this.doExecute(command3, request), this.doExecute(command4, request), this.doExecute(command5, request), Tuple::of));
    }
}

