/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.cache;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.cache.CommandCache;
import com.blibli.oss.command.cache.CommandCacheMapper;
import com.blibli.oss.command.plugin.CommandInterceptor;
import com.blibli.oss.command.properties.CommandProperties;
import java.util.Collection;

public class CommandCacheInterceptor
implements CommandInterceptor {
    private CommandProperties commandProperties;
    private CommandCache commandCache;
    private CommandCacheMapper commandCacheMapper;

    public CommandCacheInterceptor(CommandProperties commandProperties, CommandCache commandCache, CommandCacheMapper commandCacheMapper) {
        this.commandProperties = commandProperties;
        this.commandCache = commandCache;
        this.commandCacheMapper = commandCacheMapper;
    }

    @Override
    public <R, T> T beforeExecute(Command<R, T> command, R request) {
        if (!this.commandProperties.getCache().isEnabled()) {
            return null;
        }
        String cacheKey = command.cacheKey(request);
        if (cacheKey == null) {
            return null;
        }
        String result = this.commandCache.get(cacheKey);
        if (result == null) {
            return null;
        }
        Class<T> responseClass = command.responseClass();
        return this.commandCacheMapper.fromString(result, responseClass);
    }

    @Override
    public <R, T> void afterSuccessExecute(Command<R, T> command, R request, T response) {
        if (this.commandProperties.getCache().isEnabled()) {
            this.evictCommandResponse(command, request);
            this.cacheCommandResponse(command, request, response);
        }
    }

    private <R, T> void cacheCommandResponse(Command<R, T> command, R request, T response) {
        String cacheKey = command.cacheKey(request);
        if (cacheKey != null) {
            String result = this.commandCacheMapper.toString(response);
            this.commandCache.cache(cacheKey, result);
        }
    }

    private <R, T> void evictCommandResponse(Command<R, T> command, R request) {
        Collection<String> evictKeys = command.evictKeys(request);
        if (evictKeys != null) {
            for (String evictKey : evictKeys) {
                this.commandCache.evict(evictKey);
            }
        }
    }
}

