/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.sleuth.configuration;

import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldCustomizer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import com.blibli.oss.backend.sleuth.fields.SleuthExtraFieldConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SleuthConfiguration {
    public static final String HTTP_BAGGAGE_PREFIX = "baggage-";
    public static final String MESSAGING_BAGGAGE_PREFIX = "baggage_";
    @Autowired(required=false)
    private ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder;
    @Autowired(required=false)
    private List<ExtraFieldCustomizer> extraFieldCustomizers = new ArrayList<ExtraFieldCustomizer>();

    @Bean
    public Propagation.Factory sleuthPropagation(SleuthExtraFieldConfiguration extraFieldConfiguration, SleuthProperties sleuthProperties) {
        List<String> baggageKeys = extraFieldConfiguration.getExtraFields(sleuthProperties.getBaggageKeys());
        if (baggageKeys.isEmpty() && sleuthProperties.getPropagationKeys().isEmpty() && this.extraFieldCustomizers.isEmpty() && this.extraFieldPropagationFactoryBuilder == null && sleuthProperties.getLocalKeys().isEmpty()) {
            return B3Propagation.FACTORY;
        }
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = this.extraFieldPropagationFactoryBuilder != null ? this.extraFieldPropagationFactoryBuilder : ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!baggageKeys.isEmpty()) {
            factoryBuilder.addPrefixedFields(HTTP_BAGGAGE_PREFIX, baggageKeys).addPrefixedFields(MESSAGING_BAGGAGE_PREFIX, baggageKeys);
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key : sleuthProperties.getPropagationKeys()) {
                factoryBuilder.addField(key);
            }
        }
        if (!sleuthProperties.getLocalKeys().isEmpty()) {
            for (String key : sleuthProperties.getLocalKeys()) {
                factoryBuilder.addRedactedField(key);
            }
        }
        for (ExtraFieldCustomizer customizer : this.extraFieldCustomizers) {
            customizer.customize(factoryBuilder);
        }
        return factoryBuilder.build();
    }

    @Bean
    public SleuthExtraFieldConfiguration sleuthExtraFieldConfiguration() {
        return new SleuthExtraFieldConfiguration();
    }
}

