/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.impl.repository;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.spring.data.impl.repository.BlazePersistenceRepositoryFactory;
import com.blazebit.persistence.view.EntityViewManager;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.util.Assert;

public class BlazePersistenceRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private EntityManager entityManager;
    @Autowired
    private CriteriaBuilderFactory cbf;
    @Autowired
    private EntityViewManager evm;

    protected BlazePersistenceRepositoryFactoryBean() {
        super(null);
    }

    protected BlazePersistenceRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public boolean isSingleton() {
        return true;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        if (this.entityManager == null) {
            this.entityManager = entityManager;
        }
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    protected BlazePersistenceRepositoryFactory doCreateRepositoryFactory() {
        return this.createRepositoryFactory(this.entityManager);
    }

    protected BlazePersistenceRepositoryFactory createRepositoryFactory(EntityManager entityManager) {
        return new BlazePersistenceRepositoryFactory(entityManager, this.cbf, this.evm);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.entityManager, (String)"EntityManager must not be null!");
        super.afterPropertiesSet();
    }

    public void setEscapeCharacter(char escapeCharacter) {
    }

    public char getEscapeCharacter() {
        return '\\';
    }
}

