/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.impl.AbstractEntityViewConfigurationSource;
import com.blazebit.persistence.integration.view.spring.impl.EntityViewConfigurationProducer;
import com.blazebit.persistence.view.EntityView;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class EntityViewConfigurationDelegate {
    private final AbstractEntityViewConfigurationSource configurationSource;
    private final ResourceLoader resourceLoader;
    private final Environment environment;

    public EntityViewConfigurationDelegate(AbstractEntityViewConfigurationSource configurationSource, ResourceLoader resourceLoader, Environment environment) {
        this.configurationSource = configurationSource;
        this.resourceLoader = resourceLoader;
        this.environment = environment;
    }

    void registerEntityViews(BeanDefinitionRegistry registry) {
        HashSet<Class> entityViewClasses = new HashSet<Class>();
        HashSet<Class> entityViewListenerClasses = new HashSet<Class>();
        for (BeanDefinition candidate : this.configurationSource.getCandidates(this.resourceLoader)) {
            try {
                Class clazz = ClassUtils.forName((String)candidate.getBeanClassName(), this.resourceLoader == null ? null : this.resourceLoader.getClassLoader());
                if (clazz.isAnnotationPresent(EntityView.class)) {
                    entityViewClasses.add(clazz);
                    continue;
                }
                entityViewListenerClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        String entityViewClassHolderBeanName = "entityViewConfigurationProducer";
        if (registry.containsBeanDefinition("entityViewConfigurationProducer")) {
            BeanDefinition existingClassHolder = registry.getBeanDefinition("entityViewConfigurationProducer");
            Set existingEntityViewClasses = (Set)((ConstructorArgumentValues.ValueHolder)((GenericBeanDefinition)existingClassHolder).getConstructorArgumentValues().getGenericArgumentValues().get(0)).getValue();
            Set existingEntityViewListenerClasses = (Set)((ConstructorArgumentValues.ValueHolder)((GenericBeanDefinition)existingClassHolder).getConstructorArgumentValues().getGenericArgumentValues().get(1)).getValue();
            existingEntityViewClasses.addAll(entityViewClasses);
            existingEntityViewListenerClasses.addAll(entityViewListenerClasses);
        } else {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(EntityViewConfigurationProducer.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(entityViewClasses);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(entityViewListenerClasses);
            registry.registerBeanDefinition("entityViewConfigurationProducer", (BeanDefinition)beanDefinition);
        }
    }
}

