/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Constants;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaCollection;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaMap;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaSingularAttribute;
import com.blazebit.persistence.view.processor.convert.TypeConverter;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;

public class MetaAttributeGenerationVisitor
extends SimpleTypeVisitor6<AnnotationMetaAttribute, Element> {
    private final AnnotationMetaEntityView entity;
    private final Context context;
    private TypeVariable processingTypeVariable;

    MetaAttributeGenerationVisitor(AnnotationMetaEntityView entity, Context context) {
        this.entity = entity;
        this.context = context;
    }

    @Override
    public AnnotationMetaAttribute visitPrimitive(PrimitiveType t, Element element) {
        String type = TypeUtils.toWrapperTypeString(t);
        String realType = TypeUtils.toTypeString((DeclaredType)this.entity.getTypeElement().asType(), t, this.context);
        return new AnnotationMetaSingularAttribute(this.entity, element, type, realType, null, this.context);
    }

    @Override
    public AnnotationMetaAttribute visitArray(ArrayType t, Element element) {
        String type = TypeUtils.toWrapperTypeString(t);
        String realType = TypeUtils.toTypeString((DeclaredType)this.entity.getTypeElement().asType(), t.getComponentType(), this.entity.getContext()) + "[]";
        return new AnnotationMetaSingularAttribute(this.entity, element, type, realType, null, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationMetaAttribute visitTypeVariable(TypeVariable t, Element element) {
        TypeMirror mirror = TypeUtils.asMemberOf(this.context, (DeclaredType)this.entity.getTypeElement().asType(), element);
        TypeVariable old = this.processingTypeVariable;
        this.processingTypeVariable = t;
        try {
            AnnotationMetaAttribute annotationMetaAttribute = mirror.accept(this, element);
            return annotationMetaAttribute;
        }
        finally {
            this.processingTypeVariable = old;
        }
    }

    @Override
    public AnnotationMetaAttribute visitDeclared(DeclaredType declaredType, Element element) {
        DeclaredType entityDeclaredType = (DeclaredType)this.entity.getTypeElement().asType();
        TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
        String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
        if (collection != null && TypeUtils.getAnnotationMirror(element, "com.blazebit.persistence.view.MappingSingular") == null && TypeUtils.getAnnotationMirror(element, "com.blazebit.persistence.view.MappingParameter") == null) {
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() == 0) {
                this.context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type arguments for " + declaredType);
            }
            TypeMirror elementTypeMirror = typeArguments.get(typeArguments.size() - 1);
            String elementType = TypeUtils.extractClosestRealTypeAsString(elementTypeMirror, this.context);
            String realElementType = TypeUtils.toTypeString(entityDeclaredType, elementTypeMirror, this.context);
            String elementCollectionType = null;
            String realElementCollectionType = null;
            if (Constants.COLLECTIONS.containsKey(elementType)) {
                collection = collection.equals("com.blazebit.persistence.view.metamodel.MethodMapAttribute") ? "com.blazebit.persistence.view.metamodel.MethodMultiMapAttribute" : "com.blazebit.persistence.view.metamodel.MethodMultiListAttribute";
                elementCollectionType = elementType;
                List<? extends TypeMirror> elementTypeArguments = ((DeclaredType)elementTypeMirror).getTypeArguments();
                realElementCollectionType = TypeUtils.toTypeString(entityDeclaredType, elementTypeMirror, this.context);
                elementTypeMirror = elementTypeArguments.get(elementTypeArguments.size() - 1);
                elementType = TypeUtils.extractClosestRealTypeAsString(elementTypeMirror, this.context);
            }
            if (collection.equals("com.blazebit.persistence.view.metamodel.MethodMapAttribute") || collection.equals("com.blazebit.persistence.view.metamodel.MethodMultiMapAttribute")) {
                TypeMirror keyTypeMirror = typeArguments.get(0);
                String keyType = TypeUtils.extractClosestRealTypeAsString(keyTypeMirror, this.context);
                String realKeyType = TypeUtils.toTypeString(entityDeclaredType, keyTypeMirror, this.context);
                return new AnnotationMetaMap(this.entity, element, collection, returnedElement.toString(), elementCollectionType, keyType, realKeyType, elementType, realElementType, this.context);
            }
            return new AnnotationMetaCollection(this.entity, element, collection, returnedElement.toString(), elementCollectionType, elementType, realElementType, this.context);
        }
        if (!Constants.SPECIAL.contains(fqNameOfReturnType)) {
            String modelType = returnedElement.getQualifiedName().toString();
            TypeMirror declaredTypeMirror = element instanceof ExecutableElement ? ((ExecutableElement)element).getReturnType() : element.asType();
            String declaredJavaType = TypeUtils.toTypeString(entityDeclaredType, declaredTypeMirror, this.context);
            Map<String, TypeConverter> converters = this.context.getConverter(fqNameOfReturnType);
            if (!converters.isEmpty()) {
                TypeConverter typeConverter = converters.get(declaredJavaType);
                if (typeConverter == null) {
                    typeConverter = converters.get("java.lang.Object");
                }
                if (typeConverter != null) {
                    String convertedModelType = modelType;
                    modelType = typeConverter.getUnderlyingType(entityDeclaredType, declaredTypeMirror, this.context);
                    return new AnnotationMetaSingularAttribute(this.entity, element, modelType, declaredJavaType, convertedModelType, this.context);
                }
            }
            if (!declaredTypeMirror.getKind().isPrimitive() && declaredTypeMirror.getKind() != TypeKind.TYPEVAR) {
                modelType = declaredJavaType;
            }
            return new AnnotationMetaSingularAttribute(this.entity, element, modelType, declaredJavaType, null, this.context);
        }
        return null;
    }

    @Override
    public AnnotationMetaAttribute visitExecutable(ExecutableType t, Element p) {
        if (!p.getKind().equals((Object)ElementKind.METHOD)) {
            return null;
        }
        String string = p.getSimpleName().toString();
        if ((string.startsWith("get") || string.startsWith("is")) && !t.getReturnType().getKind().equals((Object)TypeKind.VOID) && t.getParameterTypes().isEmpty()) {
            TypeMirror returnType = t.getReturnType();
            if (returnType == this.processingTypeVariable) {
                return this.context.getTypeUtils().erasure(returnType).accept(this, p);
            }
            return returnType.accept(this, p);
        }
        return null;
    }
}

