/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Constants;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityViewLifecycleMethod;
import com.blazebit.persistence.view.processor.EntityViewSpecialMemberMethod;
import com.blazebit.persistence.view.processor.EntityViewUtils;
import com.blazebit.persistence.view.processor.ForeignPackageType;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.ImportContextImpl;
import com.blazebit.persistence.view.processor.JavaTypeVariable;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.ViewFilter;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaConstructor;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaVersionAttribute;
import com.blazebit.persistence.view.processor.annotation.MetaAttributeGenerationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public class AnnotationMetaEntityView
implements MetaEntityView {
    private final ImportContext metamodelImportContext;
    private final ImportContext relationImportContext;
    private final ImportContext multiRelationImportContext;
    private final ImportContext implementationImportContext;
    private final ImportContext builderImportContext;
    private final TypeElement element;
    private final String simpleName;
    private final String qualifiedName;
    private final String derivedTypeName;
    private final String packageName;
    private final List<JavaTypeVariable> typeVariables;
    private final Element[] originatingElements;
    private final String entityClass;
    private final String jpaManagedBaseClass;
    private final String entityVersionAttributeName;
    private final EntityViewLifecycleMethod postCreate;
    private final EntityViewLifecycleMethod postLoad;
    private final MetaAttribute idMember;
    private final MetaAttribute versionMember;
    private final Map<String, MetaAttribute> members;
    private final List<MetaConstructor> constructors;
    private final Map<String, EntityViewSpecialMemberMethod> specialMembers;
    private final Map<String, ForeignPackageType> foreignPackageSuperTypes;
    private final List<String> foreignPackageSuperTypeVariables;
    private final Map<String, String> optionalParameters;
    private final Map<String, ViewFilter> viewFilters;
    private final boolean updatable;
    private final boolean creatable;
    private final boolean allSupportDirtyTracking;
    private final int mutableAttributeCount;
    private final int defaultDirtyMask;
    private final boolean hasEmptyConstructor;
    private final boolean hasSelfConstructor;
    private final boolean hasSubviews;
    private final boolean hasCustomEqualsOrHashCodeMethod;
    private final boolean hasCustomToStringMethod;
    private final boolean valid;
    private final Context context;
    private final Set<String> addedAccessors = new HashSet<String>();

    /*
     * WARNING - void declaration
     */
    public AnnotationMetaEntityView(TypeElement element, Context context) {
        void var36_64;
        int n;
        void var31_48;
        void var15_27;
        void var12_19;
        void var12_17;
        boolean bl;
        this.element = element;
        this.qualifiedName = element.getQualifiedName().toString();
        this.simpleName = TypeUtils.getSimpleTypeName(element);
        this.derivedTypeName = TypeUtils.getDerivedTypeName(element);
        PackageElement packageOf = context.getElementUtils().getPackageOf(element);
        this.packageName = packageOf.getQualifiedName().toString();
        this.context = context;
        this.hasCustomEqualsOrHashCodeMethod = AnnotationMetaEntityView.hasCustom(context, element, "equals", "java.lang.Object") || AnnotationMetaEntityView.hasCustom(context, element, "hashCode", new String[0]);
        this.hasCustomToStringMethod = AnnotationMetaEntityView.hasCustom(context, element, "toString", new String[0]);
        this.metamodelImportContext = new ImportContextImpl(this.getPackageName());
        this.relationImportContext = new ImportContextImpl(this.getPackageName());
        this.multiRelationImportContext = new ImportContextImpl(this.getPackageName());
        this.implementationImportContext = new ImportContextImpl(this.getPackageName());
        this.builderImportContext = new ImportContextImpl(this.getPackageName());
        context.addMetaEntityViewToContext(this.getQualifiedName(), this);
        context.logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        List<? extends TypeMirror> typeArguments = ((DeclaredType)element.asType()).getTypeArguments();
        ArrayList<JavaTypeVariable> typeVariables = new ArrayList<JavaTypeVariable>(typeArguments.size());
        for (TypeVariable typeVariable : typeArguments) {
            typeVariables.add(new JavaTypeVariable(typeVariable));
        }
        this.typeVariables = typeVariables;
        String entityClass = null;
        boolean bl2 = false;
        boolean creatable = false;
        boolean allSupportDirtyTracking = true;
        HashMap<String, ViewFilter> viewFilters = new HashMap<String, ViewFilter>();
        block15: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            switch (annotationMirror.getAnnotationType().toString()) {
                case "com.blazebit.persistence.view.EntityView": {
                    entityClass = TypeUtils.getAnnotationValue(annotationMirror, "value").toString();
                    break;
                }
                case "com.blazebit.persistence.view.UpdatableEntityView": {
                    bl = true;
                    break;
                }
                case "com.blazebit.persistence.view.CreatableEntityView": {
                    creatable = true;
                    break;
                }
                case "com.blazebit.persistence.view.ViewFilter": {
                    AnnotationMetaEntityView.addViewFilter(viewFilters, annotationMirror, context);
                    break;
                }
                case "com.blazebit.persistence.view.ViewFilters": {
                    for (AnnotationMirror value : (List)TypeUtils.getAnnotationValue(annotationMirror, "value")) {
                        AnnotationMetaEntityView.addViewFilter(viewFilters, value, context);
                    }
                    continue block15;
                }
            }
        }
        Element entityVersionAttribute = null;
        Object var12_15 = null;
        TypeElement entityTypeElement = context.getTypeElement(entityClass);
        for (Element element2 : context.getAllMembers(entityTypeElement)) {
            if (!TypeUtils.containsAnnotation(element2, "javax.persistence.Version")) continue;
            entityVersionAttribute = element2;
            break;
        }
        if (AnnotationMetaEntityView.isEntity(entityTypeElement)) {
            TypeElement entityElement = entityTypeElement;
            while (AnnotationMetaEntityView.isEntity(entityTypeElement = context.getTypeElement(TypeUtils.extractClosestRealTypeAsString(entityElement.getSuperclass(), context)))) {
                entityElement = entityTypeElement;
            }
            String string = entityElement.getQualifiedName().toString();
        }
        if (var12_17 == null) {
            String string = entityTypeElement.getQualifiedName().toString();
        }
        this.entityVersionAttributeName = EntityViewUtils.getAttributeName(entityVersionAttribute);
        this.entityClass = entityClass;
        this.jpaManagedBaseClass = var12_19;
        this.updatable = bl;
        this.creatable = creatable;
        this.viewFilters = viewFilters;
        Iterable<? extends Element> allMembers = context.getAllMembers(element);
        Object var15_26 = null;
        AnnotationMetaAttribute versionMember = null;
        TreeMap<String, MetaAttribute> members = new TreeMap<String, MetaAttribute>();
        TreeMap<String, EntityViewSpecialMemberMethod> specialMembers = new TreeMap<String, EntityViewSpecialMemberMethod>();
        ArrayList<MetaConstructor> constructors = new ArrayList<MetaConstructor>();
        MetaAttributeGenerationVisitor visitor = new MetaAttributeGenerationVisitor(this, context);
        HashMap<String, TypeMirror> optionalParameters = new HashMap<String, TypeMirror>();
        boolean valid = true;
        boolean hasEmptyConstructor = false;
        boolean hasSelfConstructor = false;
        boolean hasSubviews = false;
        ExecutableElement postCreate = null;
        ExecutableElement postLoad = null;
        HashSet<TypeElement> originatingElements = new HashSet<TypeElement>();
        originatingElements.add(element);
        ArrayList<ExecutableElement> constructorElements = new ArrayList<ExecutableElement>();
        for (Element element3 : allMembers) {
            if (!(element3 instanceof ExecutableElement)) continue;
            ExecutableElement executableElement = (ExecutableElement)element3;
            Set<Modifier> modifiers = element3.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC)) continue;
            if (Constants.SPECIAL.contains(executableElement.getReturnType().toString())) {
                specialMembers.put(element3.getSimpleName().toString(), new EntityViewSpecialMemberMethod(executableElement));
                continue;
            }
            if (modifiers.contains((Object)Modifier.ABSTRACT) && this.isGetterOrSetter(element3)) {
                AnnotationMetaAttribute result = element3.asType().accept(visitor, element3);
                if (result == null) continue;
                if (result.isIdMember()) {
                    AnnotationMetaAttribute annotationMetaAttribute = result;
                } else if (result.isVersion()) {
                    versionMember = result;
                }
                members.put(result.getPropertyName(), result);
                for (Map.Entry<Object, Object> entry : result.getOptionalParameters().entrySet()) {
                    TypeMirror typeElement = (TypeMirror)entry.getValue();
                    TypeMirror existingTypeElement = (TypeMirror)optionalParameters.get(entry.getKey());
                    if (existingTypeElement != null && !context.getTypeUtils().isAssignable(typeElement, existingTypeElement)) continue;
                    optionalParameters.put((String)entry.getKey(), (TypeMirror)entry.getValue());
                }
                result.getOptionalParameters().clear();
                if (!result.isSubview()) continue;
                hasSubviews = true;
                originatingElements.add(result.getSubviewElement().getTypeElement());
                continue;
            }
            if (!modifiers.contains((Object)Modifier.PRIVATE) && element3.getKind() == ElementKind.CONSTRUCTOR) {
                constructorElements.add(executableElement);
                continue;
            }
            if (!TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostCreate", "com.blazebit.persistence.view.PostLoad")) continue;
            if (TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostCreate")) {
                if (postCreate == null) {
                    postCreate = executableElement;
                } else if (context.getTypeUtils().isAssignable(executableElement.getEnclosingElement().asType(), postCreate.getEnclosingElement().asType())) {
                    postCreate = executableElement;
                }
            }
            if (!TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostLoad")) continue;
            if (postLoad == null) {
                postLoad = executableElement;
                continue;
            }
            if (!context.getTypeUtils().isAssignable(executableElement.getEnclosingElement().asType(), postLoad.getEnclosingElement().asType())) continue;
            postLoad = executableElement;
        }
        TreeMap<String, String> overallOptionalParameters = new TreeMap<String, String>();
        for (Map.Entry entry : optionalParameters.entrySet()) {
            overallOptionalParameters.put((String)entry.getKey(), ((TypeMirror)entry.getValue()).toString());
        }
        for (ExecutableElement executableElement : constructorElements) {
            HashMap<String, TypeMirror> constructorOptionalParameters = new HashMap<String, TypeMirror>();
            AnnotationMetaConstructor constructor = new AnnotationMetaConstructor(this, optionalParameters, constructorOptionalParameters, executableElement, visitor, context);
            hasEmptyConstructor = hasEmptyConstructor || constructor.getParameters().isEmpty();
            hasSelfConstructor = hasSelfConstructor || constructor.hasSelfParameter();
            constructors.add(constructor);
            for (Map.Entry<Object, Object> entry : constructorOptionalParameters.entrySet()) {
                TypeMirror existingTypeElement = (TypeMirror)optionalParameters.get(entry.getKey());
                TypeMirror typeElement = (TypeMirror)entry.getValue();
                if (existingTypeElement == null || !context.getTypeUtils().isAssignable(typeElement, existingTypeElement)) continue;
                overallOptionalParameters.put((String)entry.getKey(), ((TypeMirror)entry.getValue()).toString());
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        int index = 0;
        if (var15_27 != null) {
            var15_27.setAttributeIndex(index);
            ++index;
        }
        if (versionMember == null && bl && entityVersionAttribute != null) {
            versionMember = new AnnotationMetaVersionAttribute(this, entityVersionAttribute, context);
            members.put(versionMember.getPropertyName(), versionMember);
        }
        for (MetaAttribute value : members.values()) {
            if (value.getAttributeIndex() != -1) continue;
            value.setAttributeIndex(index);
            if ((creatable || bl) && value.isMutable() && value != versionMember) {
                value.setDirtyStateIndex((int)var31_48);
                if (!value.supportsDirtyTracking()) {
                    allSupportDirtyTracking = false;
                    n |= 1 << var31_48;
                }
                ++var31_48;
            }
            ++index;
        }
        this.hasEmptyConstructor = hasEmptyConstructor || constructors.isEmpty();
        this.hasSelfConstructor = hasSelfConstructor;
        this.hasSubviews = hasSubviews;
        this.valid = valid;
        this.allSupportDirtyTracking = allSupportDirtyTracking;
        this.mutableAttributeCount = var31_48;
        this.defaultDirtyMask = n;
        if (constructors.isEmpty()) {
            constructors.add(new AnnotationMetaConstructor(this, optionalParameters));
        } else {
            constructors.sort(MetaConstructor.NAME_COMPARATOR);
        }
        LinkedHashMap<String, ForeignPackageType> foreignPackageSuperTypes = new LinkedHashMap<String, ForeignPackageType>();
        ArrayList<String> foreignPackageSuperTypeVariables = new ArrayList<String>();
        TypeMirror typeMirror = element.getSuperclass();
        PackageElement elementPackage = context.getElementUtils().getPackageOf(element);
        while (var36_64.getKind() == TypeKind.DECLARED) {
            String string;
            PackageElement superClassPackage;
            TypeElement superClassElement = (TypeElement)((DeclaredType)var36_64).asElement();
            if (superClassElement.getModifiers().contains((Object)Modifier.ABSTRACT) && !elementPackage.equals(superClassPackage = context.getElementUtils().getPackageOf(superClassElement)) && !foreignPackageSuperTypes.containsKey(string = superClassPackage.getQualifiedName().toString())) {
                foreignPackageSuperTypes.put(string, new ForeignPackageType(this, superClassElement, context));
                for (TypeParameterElement typeParameterElement : superClassElement.getTypeParameters()) {
                    foreignPackageSuperTypeVariables.add(TypeUtils.asMemberOf(context, (DeclaredType)element.asType(), typeParameterElement).toString());
                }
            }
            TypeMirror typeMirror2 = superClassElement.getSuperclass();
        }
        TypeElement superclass = element;
        while (superclass.getKind() == ElementKind.CLASS && !superclass.getQualifiedName().toString().equals("java.lang.Object")) {
            for (Element element4 : superclass.getEnclosedElements()) {
                element4.getModifiers();
                element4.asType();
                if (!(element4 instanceof ExecutableElement)) continue;
                ((ExecutableElement)element4).getParameters();
            }
            for (TypeMirror typeMirror3 : superclass.getInterfaces()) {
                ((TypeElement)((DeclaredType)typeMirror3).asElement()).getQualifiedName().toString();
            }
            superclass = (TypeElement)((DeclaredType)superclass.getSuperclass()).asElement();
        }
        this.idMember = var15_27;
        this.versionMember = versionMember;
        this.members = members;
        this.constructors = constructors;
        this.specialMembers = specialMembers;
        this.foreignPackageSuperTypes = foreignPackageSuperTypes;
        this.foreignPackageSuperTypeVariables = foreignPackageSuperTypeVariables;
        this.optionalParameters = overallOptionalParameters;
        this.postCreate = postCreate == null ? null : new EntityViewLifecycleMethod(postCreate);
        this.postLoad = postLoad == null ? null : new EntityViewLifecycleMethod(postLoad);
        this.originatingElements = originatingElements.toArray(new Element[0]);
    }

    private static boolean isEntity(TypeElement typeElement) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("javax.persistence.Entity")) continue;
            return true;
        }
        return false;
    }

    private static void addViewFilter(Map<String, ViewFilter> filters, AnnotationMirror mirror, Context context) {
        String name = "";
        TypeMirror type = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            switch (entry.getKey().getSimpleName().toString()) {
                case "name": {
                    name = (String)entry.getValue().getValue();
                    break;
                }
                case "value": {
                    type = (TypeMirror)entry.getValue().getValue();
                    break;
                }
            }
        }
        filters.put(name, new ViewFilter(name, (TypeElement)((DeclaredType)type).asElement(), context));
    }

    public final Context getContext() {
        return this.context;
    }

    @Override
    public Map<String, ForeignPackageType> getForeignPackageSuperTypes() {
        return this.foreignPackageSuperTypes;
    }

    @Override
    public List<String> getForeignPackageSuperTypeVariables() {
        return this.foreignPackageSuperTypeVariables;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }

    @Override
    public boolean isAllSupportDirtyTracking() {
        return this.allSupportDirtyTracking;
    }

    @Override
    public int getMutableAttributeCount() {
        return this.mutableAttributeCount;
    }

    @Override
    public boolean hasEmptyConstructor() {
        return this.hasEmptyConstructor;
    }

    @Override
    public boolean hasSelfConstructor() {
        return this.hasSelfConstructor;
    }

    @Override
    public boolean hasSubviews() {
        return this.hasSubviews;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getBaseSuperclass() {
        Iterator<ForeignPackageType> iterator = this.foreignPackageSuperTypes.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getName() + "_" + this.getQualifiedName().replace('.', '_');
        }
        return this.getQualifiedName();
    }

    @Override
    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getDerivedTypeName() {
        return this.derivedTypeName;
    }

    @Override
    public List<JavaTypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public String getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getJpaManagedBaseClass() {
        return this.jpaManagedBaseClass;
    }

    @Override
    public String getEntityVersionAttributeName() {
        return this.entityVersionAttributeName;
    }

    @Override
    public EntityViewLifecycleMethod getPostCreateForReflection() {
        return this.postCreate;
    }

    @Override
    public EntityViewLifecycleMethod getPostLoad() {
        return this.postLoad;
    }

    @Override
    public final String getPackageName() {
        return this.packageName;
    }

    @Override
    public MetaAttribute getIdMember() {
        return this.idMember;
    }

    @Override
    public MetaAttribute getVersionMember() {
        return this.versionMember;
    }

    @Override
    public int getDefaultDirtyMask() {
        return this.defaultDirtyMask;
    }

    @Override
    public Collection<MetaConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public Collection<MetaAttribute> getMembers() {
        return this.members.values();
    }

    @Override
    public Collection<EntityViewSpecialMemberMethod> getSpecialMembers() {
        return this.specialMembers.values();
    }

    @Override
    public ImportContext getMetamodelImportContext() {
        return this.metamodelImportContext;
    }

    @Override
    public ImportContext getRelationImportContext() {
        return this.relationImportContext;
    }

    @Override
    public ImportContext getMultiRelationImportContext() {
        return this.multiRelationImportContext;
    }

    @Override
    public ImportContext getImplementationImportContext() {
        return this.implementationImportContext;
    }

    @Override
    public ImportContext getBuilderImportContext() {
        return this.builderImportContext;
    }

    @Override
    public final String importType(String fqcn) {
        this.implementationImportContext.importType(fqcn);
        this.metamodelImportContext.importType(fqcn);
        this.relationImportContext.importType(fqcn);
        this.multiRelationImportContext.importType(fqcn);
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public String importTypeExceptMetamodel(String fqcn) {
        this.implementationImportContext.importType(fqcn);
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public String metamodelImportType(String fqcn) {
        return this.metamodelImportContext.importType(fqcn);
    }

    @Override
    public String relationImportType(String fqcn) {
        return this.relationImportContext.importType(fqcn);
    }

    @Override
    public String multiRelationImportType(String fqcn) {
        return this.multiRelationImportContext.importType(fqcn);
    }

    @Override
    public String implementationImportType(String fqcn) {
        return this.implementationImportContext.importType(fqcn);
    }

    @Override
    public String builderImportType(String fqcn) {
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public final TypeElement getTypeElement() {
        return this.element;
    }

    @Override
    public ElementKind getElementKind() {
        return this.element.getKind();
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    @Override
    public Element[] getOriginatingElements() {
        return this.originatingElements;
    }

    @Override
    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }

    @Override
    public Map<String, ViewFilter> getViewFilters() {
        return this.viewFilters;
    }

    @Override
    public String getSafeTypeVariable(String typeVariable) {
        if (this.typeVariables.isEmpty()) {
            return typeVariable;
        }
        String originalTypeVariable = typeVariable;
        int suffix = 0;
        block0: while (true) {
            for (JavaTypeVariable variable : this.typeVariables) {
                if (!typeVariable.equals(variable.getName())) continue;
                typeVariable = originalTypeVariable + suffix++;
                continue block0;
            }
            break;
        }
        return typeVariable;
    }

    private boolean isGetterOrSetter(Element methodOfClass) {
        if (methodOfClass instanceof ExecutableElement) {
            ExecutableType methodType = (ExecutableType)methodOfClass.asType();
            String methodSimpleName = methodOfClass.getSimpleName().toString();
            List<? extends TypeMirror> methodParameterTypes = methodType.getParameterTypes();
            TypeMirror returnType = methodType.getReturnType();
            if (methodSimpleName.startsWith("set") && methodParameterTypes.size() == 1 && "void".equalsIgnoreCase(returnType.toString())) {
                return true;
            }
            if ((methodSimpleName.startsWith("get") || methodSimpleName.startsWith("is")) && methodParameterTypes.isEmpty() && !"void".equalsIgnoreCase(returnType.toString())) {
                return true;
            }
        }
        return false;
    }

    public boolean addAccessorForType(String realType) {
        return this.addedAccessors.add(realType);
    }

    @Override
    public boolean hasCustomEqualsOrHashCodeMethod() {
        return this.hasCustomEqualsOrHashCodeMethod;
    }

    @Override
    public boolean hasCustomToStringMethod() {
        return this.hasCustomToStringMethod;
    }

    private static boolean hasCustom(Context context, TypeElement typeElement, String methodName, String ... argumentTypes) {
        if (typeElement.getQualifiedName().toString().equals("java.lang.Object")) {
            return false;
        }
        block0: for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            List<? extends VariableElement> parameters;
            if (!(element instanceof ExecutableElement) || !methodName.equals(element.getSimpleName().toString()) || argumentTypes.length != (parameters = (executableElement = (ExecutableElement)element).getParameters()).size()) continue;
            for (int i = 0; i < argumentTypes.length; ++i) {
                String argumentType = argumentTypes[i];
                if (!argumentType.equals(parameters.get(i).asType().toString())) continue block0;
            }
            return true;
        }
        if (typeElement.getSuperclass().getKind() == TypeKind.NONE) {
            return false;
        }
        TypeElement superClass = typeElement.getSuperclass() instanceof DeclaredType ? (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement() : context.getTypeElement(((TypeElement)((Object)typeElement.getSuperclass())).getQualifiedName());
        return AnnotationMetaEntityView.hasCustom(context, superClass, methodName, argumentTypes);
    }
}

