/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.AttributeFilter;
import com.blazebit.persistence.view.processor.ClassWriter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.ViewFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import javax.tools.FileObject;

public final class MetamodelClassWriter
extends ClassWriter {
    public static final String META_MODEL_CLASS_NAME_SUFFIX = "_";
    private static final String NEW_LINE = System.lineSeparator();

    private MetamodelClassWriter(FileObject fileObject, MetaEntityView entity, Context context, Collection<Runnable> mainThreadQueue, LongAdder elapsedTime) {
        super(fileObject, entity, entity.getMetamodelImportContext(), context, mainThreadQueue, elapsedTime);
    }

    public static void writeFile(MetaEntityView entity, Context context, ExecutorService executorService, Collection<Runnable> mainThreadQueue, LongAdder metamodelTime) {
        FileObject fileObject = ClassWriter.createFile(entity.getPackageName(), entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX, context, entity.getOriginatingElements());
        if (fileObject == null) {
            return;
        }
        executorService.submit(new MetamodelClassWriter(fileObject, entity, context, mainThreadQueue, metamodelTime));
    }

    @Override
    public void generateBody(StringBuilder sb, MetaEntityView entity, Context context) {
        Map<String, String> optionalParameters;
        if (context.addGeneratedAnnotation()) {
            ClassWriter.writeGeneratedAnnotation(sb, entity.getMetamodelImportContext(), context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriter.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        sb.append("@").append(entity.metamodelImportType("com.blazebit.persistence.view.StaticMetamodel")).append("(").append(entity.metamodelImportType(entity.getQualifiedName())).append(".class)");
        sb.append(NEW_LINE);
        sb.append("public abstract class ").append(entity.getSimpleName()).append(META_MODEL_CLASS_NAME_SUFFIX).append(" {");
        sb.append(NEW_LINE);
        Collection<MetaAttribute> members = entity.getMembers();
        for (MetaAttribute metaAttribute : members) {
            if (metaAttribute.isSynthetic()) continue;
            metaAttribute.appendMetamodelAttributeDeclarationString(sb, entity.getMetamodelImportContext());
            sb.append(NEW_LINE);
        }
        for (MetaAttribute metaAttribute : members) {
            if (metaAttribute.isSynthetic()) continue;
            for (AttributeFilter attributeFilter : metaAttribute.getFilters()) {
                sb.append("    public static volatile ").append(entity.metamodelImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMapping")).append('<');
                sb.append(entity.metamodelImportType(entity.getQualifiedName())).append(", ");
                attributeFilter.getFilterValueType().append(entity.getMetamodelImportContext(), sb);
                sb.append("> ").append(metaAttribute.getPropertyName()).append('_');
                if (attributeFilter.getName().isEmpty()) {
                    sb.append("filter");
                } else {
                    sb.append(attributeFilter.getName());
                }
                sb.append(";").append(NEW_LINE);
            }
        }
        sb.append(NEW_LINE);
        for (MetaAttribute metaAttribute : members) {
            if (metaAttribute.isSynthetic()) continue;
            metaAttribute.appendMetamodelAttributeNameDeclarationString(sb, entity.getMetamodelImportContext());
            sb.append(NEW_LINE);
        }
        if (context.isGenerateDeepConstants() && entity.hasSubviews()) {
            MetamodelClassWriter.generateNestedClasses("", "", sb, entity, context, new HashMap<String, MetaEntityView>(context.getMetaEntityViewMap()), new HashSet<MetaEntityView>());
        }
        sb.append(NEW_LINE);
        for (MetaConstructor metaConstructor : entity.getConstructors()) {
            optionalParameters = metaConstructor.getOptionalParameters();
            sb.append("    public static ").append(entity.metamodelImportType("com.blazebit.persistence.view.EntityViewSetting")).append("<").append(entity.metamodelImportType(entity.getQualifiedName())).append(", ").append(entity.metamodelImportType("com.blazebit.persistence.CriteriaBuilder")).append("<").append(entity.metamodelImportType(entity.getQualifiedName())).append(">> createSetting");
            sb.append(Character.toUpperCase(metaConstructor.getName().charAt(0))).append(metaConstructor.getName(), 1, metaConstructor.getName().length());
            sb.append("(");
            if (!optionalParameters.isEmpty()) {
                for (Map.Entry<String, String> entry2 : optionalParameters.entrySet()) {
                    sb.append(entity.metamodelImportType(entry2.getValue())).append(" ").append(entry2.getKey()).append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
            sb.append(") {").append(NEW_LINE);
            sb.append("        return EntityViewSetting.create(").append(entity.metamodelImportType(entity.getQualifiedName())).append(".class, \"").append(metaConstructor.getName()).append("\")");
            for (Map.Entry<String, String> entry2 : optionalParameters.entrySet()) {
                sb.append(NEW_LINE).append("            .withOptionalParameter(\"").append(entry2.getKey()).append("\", ").append(entry2.getKey()).append(")");
            }
            sb.append(";").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    public static ").append(entity.metamodelImportType("com.blazebit.persistence.view.EntityViewSetting")).append("<").append(entity.metamodelImportType(entity.getQualifiedName())).append(", ").append(entity.metamodelImportType("com.blazebit.persistence.PaginatedCriteriaBuilder")).append("<").append(entity.metamodelImportType(entity.getQualifiedName())).append(">> createPaginatedSetting");
            sb.append(Character.toUpperCase(metaConstructor.getName().charAt(0))).append(metaConstructor.getName(), 1, metaConstructor.getName().length());
            sb.append("(int firstResult, int maxResults");
            for (Map.Entry<String, String> entry2 : optionalParameters.entrySet()) {
                sb.append(", ").append(entity.metamodelImportType(entry2.getValue())).append(" ").append(entry2.getKey());
            }
            sb.append(") {").append(NEW_LINE);
            sb.append("        return EntityViewSetting.create(").append(entity.metamodelImportType(entity.getQualifiedName())).append(".class, firstResult, maxResults, \"").append(metaConstructor.getName()).append("\")");
            for (Map.Entry<String, String> entry2 : optionalParameters.entrySet()) {
                sb.append(NEW_LINE).append("            .withOptionalParameter(\"").append(entry2.getKey()).append("\", ").append(entry2.getKey()).append(")");
            }
            sb.append(";").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        for (Map.Entry entry : entity.getViewFilters().entrySet()) {
            optionalParameters = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry2 : ((ViewFilter)entry.getValue()).getOptionalParameters().entrySet()) {
                if (context.getOptionalParameters().containsKey(entry2.getKey()) || entity.getOptionalParameters().containsKey(entry2.getKey())) continue;
                optionalParameters.put(entry2.getKey(), entry2.getValue());
            }
            sb.append("    public static void apply");
            String string = (String)entry.getKey();
            sb.append(Character.toUpperCase(string.charAt(0))).append(string, 1, string.length());
            sb.append("(").append(entity.metamodelImportType("com.blazebit.persistence.view.EntityViewSetting")).append("<").append(entity.metamodelImportType(entity.getQualifiedName())).append(", ?> setting");
            for (Map.Entry<String, String> entry3 : optionalParameters.entrySet()) {
                sb.append(", ").append(entity.metamodelImportType(entry3.getValue())).append(" ").append(entry3.getKey());
            }
            sb.append(") {").append(NEW_LINE);
            sb.append("        setting.withViewFilter(\"").append(string).append("\")");
            for (Map.Entry<String, String> entry3 : optionalParameters.entrySet()) {
                sb.append(NEW_LINE).append("            .withOptionalParameter(\"").append(entry3.getKey()).append("\", ").append(entry3.getKey()).append(")");
            }
            sb.append(";").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append("}");
        sb.append(NEW_LINE);
    }

    private static void generateNestedClasses(String parentProperty, String parent, StringBuilder sb, MetaEntityView entity, Context context, Map<String, MetaEntityView> entityViewMap, Set<MetaEntityView> visited) {
        if (visited.add(entity)) {
            for (MetaAttribute metaMember : entity.getMembers()) {
                String newParentProperty;
                StringBuilder tempSb;
                String newParent;
                if (!metaMember.isSubview()) continue;
                MetaEntityView subviewEntityView = metaMember.getSubviewElement();
                if (parent.isEmpty()) {
                    newParent = metaMember.getPropertyName();
                    tempSb = new StringBuilder();
                    MetamodelClassWriter.appendPropertyNameAsConstant(tempSb, metaMember.getPropertyName());
                    newParentProperty = tempSb.toString();
                } else {
                    newParent = parent + "." + metaMember.getPropertyName();
                    tempSb = new StringBuilder(parentProperty).append("__");
                    MetamodelClassWriter.appendPropertyNameAsConstant(tempSb, metaMember.getPropertyName());
                    newParentProperty = tempSb.toString();
                }
                for (MetaAttribute subviewMetaMember : subviewEntityView.getMembers()) {
                    sb.append("    ").append("public static final String ").append(newParentProperty);
                    MetamodelClassWriter.appendPropertyNameAsConstant(sb, subviewMetaMember.getPropertyName());
                    sb.append(" = \"").append(newParent).append(".").append(subviewMetaMember.getPropertyName()).append("\";").append(NEW_LINE);
                }
                if (!subviewEntityView.hasSubviews()) continue;
                sb.append(NEW_LINE);
                MetamodelClassWriter.generateNestedClasses(newParentProperty, newParent, sb, subviewEntityView, context, entityViewMap, visited);
            }
            visited.remove(entity);
        }
    }

    private static void appendPropertyNameAsConstant(StringBuilder sb, String propertyName) {
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
        }
    }
}

