/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.ImportContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public class JavaType {
    protected final String name;
    private final List<JavaType> typeArguments;

    public JavaType(String name) {
        this.name = name;
        this.typeArguments = Collections.emptyList();
    }

    public JavaType(TypeMirror typeMirror) {
        if (typeMirror instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)typeMirror;
            typeMirror = typeVariable.getUpperBound();
        }
        if (typeMirror instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeMirror;
            this.name = wildcardType.getExtendsBound() == null ? "? super " + wildcardType.getSuperBound().toString() : "? extends " + wildcardType.getExtendsBound().toString();
            this.typeArguments = Collections.emptyList();
        } else {
            DeclaredType filterValueType = (DeclaredType)typeMirror;
            TypeElement filterValueTypeElement = (TypeElement)filterValueType.asElement();
            this.name = filterValueTypeElement.getQualifiedName().toString();
            List<? extends TypeMirror> typeArguments = filterValueType.getTypeArguments();
            ArrayList<JavaType> arguments = new ArrayList<JavaType>(typeArguments.size());
            for (TypeMirror typeMirror2 : typeArguments) {
                arguments.add(new JavaType(typeMirror2));
            }
            this.typeArguments = arguments;
        }
    }

    public void append(ImportContext importContext, StringBuilder sb) {
        sb.append(importContext.importType(this.name));
        if (!this.typeArguments.isEmpty()) {
            sb.append("<");
            for (JavaType typeArgument : this.typeArguments) {
                typeArgument.append(importContext, sb);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(">");
        }
    }
}

