/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import java.util.ArrayList;
import java.util.List;

public class AttributeFetchGraphNode<X extends AttributeFetchGraphNode<X>>
implements FetchGraphNode<X> {
    protected final String attributeName;
    protected final String mapping;
    protected final boolean fetch;
    private final FetchGraphNode<?> nestedGraphNode;

    public AttributeFetchGraphNode(String attributeName, String mapping, boolean fetch, FetchGraphNode nestedGraphNode) {
        this.fetch = fetch;
        this.attributeName = attributeName;
        this.mapping = mapping;
        this.nestedGraphNode = nestedGraphNode;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    protected FetchGraphNode<?> getNestedGraphNode() {
        return this.nestedGraphNode;
    }

    @Override
    public void appendFetchJoinQueryFragment(String base, StringBuilder sb) {
        if (this.fetch && this.mapping != null) {
            String newBase = base.replace('.', '_') + "_" + this.attributeName;
            sb.append(" LEFT JOIN FETCH ").append(base).append('.').append(this.mapping).append(" ").append(newBase);
            FetchGraphNode<?> nestedGraphNode = this.getNestedGraphNode();
            if (nestedGraphNode != null) {
                nestedGraphNode.appendFetchJoinQueryFragment(newBase, sb);
            }
        }
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<X> fetchGraphNodes) {
        boolean newFetch;
        boolean fetchChanged = false;
        ArrayList nestedFlushers = new ArrayList(fetchGraphNodes.size());
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            AttributeFetchGraphNode node = (AttributeFetchGraphNode)fetchGraphNodes.get(i);
            fetchChanged |= this.fetch != node.fetch;
            FetchGraphNode<?> nestedGraphNode = node.getNestedGraphNode();
            if (nestedGraphNode == null) continue;
            nestedFlushers.add(nestedGraphNode);
        }
        boolean bl = newFetch = fetchChanged || this.fetch;
        if (nestedFlushers.isEmpty()) {
            if (fetchChanged && this.fetch != newFetch) {
                return new AttributeFetchGraphNode<X>(this.attributeName, this.mapping, newFetch, (FetchGraphNode)fetchGraphNodes.get(0));
            }
            return this;
        }
        FetchGraphNode firstFlusher = (FetchGraphNode)nestedFlushers.get(0);
        FetchGraphNode<?> fetchGraphNode = firstFlusher.mergeWith(nestedFlushers);
        if (!fetchChanged && fetchGraphNode == firstFlusher) {
            return this;
        }
        return new AttributeFetchGraphNode<X>(this.attributeName, this.mapping, newFetch, fetchGraphNode);
    }
}

