/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractLocalDateTimeTypeConverter;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class CalendarToLocalDateTimeTypeConverter<T extends Calendar>
extends AbstractLocalDateTimeTypeConverter<T> {
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final CalendarToLocalDateTimeTypeConverter<Calendar> JAVA_UTIL_CALENDAR_CONVERTER = new CalendarToLocalDateTimeTypeConverter<Calendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Calendar.class;
        }

        public Calendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.toEpochMillis(object));
            return calendar;
        }
    };
    public static final CalendarToLocalDateTimeTypeConverter<GregorianCalendar> JAVA_UTIL_GREGORIAN_CALENDAR_CONVERTER = new CalendarToLocalDateTimeTypeConverter<GregorianCalendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return GregorianCalendar.class;
        }

        public GregorianCalendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(UTC_TIMEZONE);
            gregorianCalendar.setTimeInMillis(this.toEpochMillis(object));
            return gregorianCalendar;
        }
    };

    public Object convertToViewType(Calendar object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochMilli(object.getTimeInMillis());
    }
}

