/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.BaseFromQueryBuilder;
import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import java.util.Map;
import javax.persistence.metamodel.EntityType;

public class SubqueryCorrelationBuilder
implements CorrelationBuilder {
    private final ParameterHolder<?> parameterHolder;
    private final Map<String, Object> optionalParameters;
    private final FullQueryBuilder<?, ?> criteriaBuilder;
    private final String correlationAlias;
    private final String correlationExternalAlias;
    private final String correlationResult;
    private final Class<?> correlationBasisType;
    private final Class<?> correlationBasisEntity;
    private final String correlationJoinBase;
    private final String attributePath;
    private final int batchSize;
    private final Limiter limiter;
    private final boolean correlateJoinBase;
    private String correlationRoot;
    private Object correlationBuilder;

    public SubqueryCorrelationBuilder(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, FullQueryBuilder<?, ?> criteriaBuilder, String correlationAlias, String correlationExternalAlias, String correlationResult, Class<?> correlationBasisType, Class<?> correlationBasisEntity, String correlationJoinBase, String attributePath, int batchSize, Limiter limiter, boolean correlateJoinBase) {
        this.parameterHolder = parameterHolder;
        this.optionalParameters = optionalParameters;
        this.criteriaBuilder = criteriaBuilder;
        this.correlationAlias = correlationAlias;
        this.correlationExternalAlias = correlationExternalAlias;
        this.correlationResult = correlationResult;
        this.correlationBasisType = correlationBasisType;
        this.correlationBasisEntity = correlationBasisEntity;
        this.correlationJoinBase = correlationJoinBase;
        this.attributePath = attributePath;
        this.batchSize = batchSize;
        this.correlateJoinBase = correlateJoinBase;
        this.limiter = limiter;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.criteriaBuilder.getService(serviceClass);
    }

    public FromProvider getCorrelationFromProvider() {
        return this.criteriaBuilder;
    }

    public String getCorrelationAlias() {
        return this.correlationAlias;
    }

    public String getCorrelationRoot() {
        if (this.correlationBuilder instanceof SubqueryBuilder) {
            ((SubqueryBuilder)this.correlationBuilder).end();
        } else if (this.correlationBuilder instanceof FullSelectCTECriteriaBuilder) {
            ((FullSelectCTECriteriaBuilder)this.correlationBuilder).end();
        }
        return this.correlationRoot;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        JoinOnBuilder correlationBuilder;
        if (this.correlationRoot != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.batchSize > 1) {
            if (this.correlationBasisEntity != null) {
                this.criteriaBuilder.fromIdentifiableValues(this.correlationBasisEntity, this.correlationJoinBase, this.batchSize);
            } else {
                this.criteriaBuilder.fromValues(this.correlationBasisType, this.correlationJoinBase, this.batchSize);
            }
            if (this.limiter == null) {
                correlationBuilder = this.criteriaBuilder.innerJoinOn(this.correlationJoinBase, entityClass, this.correlationAlias);
            } else {
                this.checkLimitSupport();
                BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.innerJoinLateralEntitySubquery(this.correlationJoinBase, entityClass, this.correlationExternalAlias, this.correlationAlias);
                this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
                this.correlationBuilder = lateralBuilder;
                correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
            }
        } else if (this.limiter == null) {
            if (this.correlateJoinBase) {
                correlationBuilder = this.criteriaBuilder.innerJoinOn(this.correlationJoinBase, entityClass, this.correlationAlias);
            } else {
                this.criteriaBuilder.from(entityClass, this.correlationAlias);
                correlationBuilder = (JoinOnBuilder)this.criteriaBuilder.getService(JoinOnBuilder.class);
            }
        } else if (this.correlateJoinBase) {
            BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.innerJoinLateralEntitySubquery(this.correlationJoinBase, entityClass, this.correlationExternalAlias, this.correlationAlias);
            this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
            this.correlationBuilder = lateralBuilder;
            correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
        } else {
            this.criteriaBuilder.from(entityClass, this.correlationExternalAlias);
            SubqueryBuilder subqueryBuilder = this.criteriaBuilder.where(this.correlationExternalAlias).in().from(entityClass, this.correlationAlias);
            this.limiter.apply(this.parameterHolder, this.optionalParameters, subqueryBuilder);
            this.correlationBuilder = subqueryBuilder;
            correlationBuilder = (JoinOnBuilder)subqueryBuilder.getService(JoinOnBuilder.class);
        }
        this.correlationRoot = this.correlationResult;
        return correlationBuilder;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        JoinOnBuilder correlationBuilder;
        if (this.correlationRoot != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.batchSize > 1) {
            if (this.correlationBasisEntity != null) {
                this.criteriaBuilder.fromIdentifiableValues(this.correlationBasisEntity, this.correlationJoinBase, this.batchSize);
            } else {
                this.criteriaBuilder.fromValues(this.correlationBasisType, this.correlationJoinBase, this.batchSize);
            }
            if (this.limiter == null) {
                correlationBuilder = this.criteriaBuilder.innerJoinOn(entityType, this.correlationAlias);
            } else {
                this.checkLimitSupport();
                BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.innerJoinLateralEntitySubquery(this.correlationJoinBase, entityType, this.correlationExternalAlias, this.correlationAlias);
                this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
                this.correlationBuilder = lateralBuilder;
                correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
            }
        } else if (this.limiter == null) {
            if (this.correlateJoinBase) {
                correlationBuilder = this.criteriaBuilder.innerJoinOn(this.correlationJoinBase, entityType, this.correlationAlias);
            } else {
                this.criteriaBuilder.from(entityType, this.correlationAlias);
                correlationBuilder = (JoinOnBuilder)this.criteriaBuilder.getService(JoinOnBuilder.class);
            }
        } else {
            this.checkLimitSupport();
            BaseFromQueryBuilder lateralBuilder = this.correlateJoinBase ? this.criteriaBuilder.innerJoinLateralEntitySubquery(this.correlationJoinBase, entityType, this.correlationExternalAlias, this.correlationAlias) : this.criteriaBuilder.innerJoinLateralEntitySubquery(entityType, this.correlationExternalAlias, this.correlationAlias);
            this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
            this.correlationBuilder = lateralBuilder;
            correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
        }
        this.correlationRoot = this.correlationResult;
        return correlationBuilder;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(String correlationPath) {
        JoinOnBuilder correlationBuilder;
        if (this.correlationRoot != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        if (this.batchSize > 1) {
            if (this.correlationBasisEntity != null) {
                this.criteriaBuilder.fromIdentifiableValues(this.correlationBasisEntity, this.correlationJoinBase, this.batchSize);
            } else {
                this.criteriaBuilder.fromValues(this.correlationBasisType, this.correlationJoinBase, this.batchSize);
            }
            if (this.limiter == null) {
                correlationBuilder = this.criteriaBuilder.innerJoinOn(correlationPath, this.correlationAlias);
            } else {
                this.checkLimitSupport();
                BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.innerJoinLateralEntitySubquery(correlationPath, this.correlationExternalAlias, this.correlationAlias);
                this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
                this.correlationBuilder = lateralBuilder;
                correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
            }
        } else if (this.limiter == null) {
            correlationBuilder = this.criteriaBuilder.innerJoinOn(correlationPath, this.correlationAlias);
        } else {
            this.checkLimitSupport();
            BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.innerJoinLateralEntitySubquery(correlationPath, this.correlationExternalAlias, this.correlationAlias);
            this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
            this.correlationBuilder = lateralBuilder;
            correlationBuilder = (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
        }
        this.correlationRoot = this.correlationResult;
        return correlationBuilder;
    }

    private void checkLimitSupport() {
        if (this.getService(DbmsDialect.class).getLateralStyle() == LateralStyle.NONE && !this.getService(DbmsDialect.class).supportsLimitInQuantifiedPredicateSubquery()) {
            throw new IllegalStateException("Can't limit the amount of elements for the attribute path " + this.attributePath + " because the DBMS doesn't support lateral or the use of LIMIT in quantified predicates! Use the SELECT strategy with batch size 1 if you really need this.");
        }
    }
}

