/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.view.impl.collection.MapInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import java.util.Map;

public class MapInstantiatorAccumulator
implements ContainerAccumulator<Map<?, ?>> {
    private final MapInstantiatorImplementor<?, ?> mapInstantiator;
    private final ContainerAccumulator<Object> valueAccumulator;
    private final boolean filterNulls;

    public MapInstantiatorAccumulator(MapInstantiatorImplementor<?, ?> mapInstantiator, ContainerAccumulator<?> valueAccumulator, boolean filterNulls) {
        this.mapInstantiator = mapInstantiator;
        this.valueAccumulator = valueAccumulator;
        this.filterNulls = filterNulls;
    }

    public MapInstantiatorImplementor<?, ?> getMapInstantiator() {
        return this.mapInstantiator;
    }

    public ContainerAccumulator<Object> getValueAccumulator() {
        return this.valueAccumulator;
    }

    @Override
    public Map<?, ?> createContainer(boolean recording, int size) {
        if (recording) {
            return this.mapInstantiator.createRecordingMap(size);
        }
        return this.mapInstantiator.createMap(size);
    }

    @Override
    public void add(Map<?, ?> container, Object index, Object value, boolean recording) {
        if (this.filterNulls && value == null) {
            return;
        }
        Object map = recording ? ((RecordingMap)container).getDelegate() : container;
        if (this.valueAccumulator == null) {
            Object oldValue = map.put(index, value);
            if (oldValue != null && !oldValue.equals(value)) {
                throw new IllegalArgumentException("Value " + value + " replaces old value " + oldValue + " for key " + index + "! Use a proper accumulator!");
            }
        } else {
            Object valueContainer = map.get(index);
            if (valueContainer == null) {
                valueContainer = this.valueAccumulator.createContainer(false, 1);
                map.put(index, valueContainer);
            }
            this.valueAccumulator.add(valueContainer, null, value, false);
        }
    }

    @Override
    public void addAll(Map<?, ?> container, Map<?, ?> value, boolean recording) {
        Object map = recording ? ((RecordingMap)container).getDelegate() : container;
        if (this.valueAccumulator == null) {
            if (this.filterNulls) {
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    if (entry.getValue() == null) continue;
                    map.put(entry.getKey(), entry.getValue());
                }
            } else {
                map.putAll(value);
            }
        } else {
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                Object valueContainer = map.get(entry.getKey());
                if (valueContainer == null) {
                    valueContainer = this.valueAccumulator.createContainer(false, 1);
                    map.put(entry.getKey(), valueContainer);
                }
                this.valueAccumulator.addAll(valueContainer, entry.getValue(), false);
            }
        }
    }

    @Override
    public boolean requiresPostConstruct() {
        return false;
    }

    @Override
    public void postConstruct(Map<?, ?> collection) {
    }
}

