/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractParameterAttribute;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.ManagedType;

public class MappingConstructorImpl<X>
implements MappingConstructor<X> {
    private final String name;
    private final ManagedViewTypeImplementor<X> declaringType;
    private final Constructor<X> javaConstructor;
    private final List<AbstractParameterAttribute<? super X, ?>> parameters;
    private final InheritanceSubtypeConstructorConfiguration<X> defaultInheritanceParametersAttributesClosureConfiguration;
    private final InheritanceSubtypeConstructorConfiguration<X> overallInheritanceParametersAttributesClosureConfiguration;
    private final Map<Map<ManagedViewType<? extends X>, String>, InheritanceSubtypeConstructorConfiguration<X>> inheritanceSubtypeParameterAttributesClosureConfigurations;
    private final boolean hasJoinFetchedCollections;
    private final boolean hasEntityAttributes;

    public MappingConstructorImpl(ManagedViewTypeImplementor<X> viewType, String name, ConstructorMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        this.name = name;
        this.declaringType = viewType;
        this.javaConstructor = mapping.getConstructor();
        List<ParameterAttributeMapping> parameterMappings = mapping.getParameterMappings();
        int parameterCount = parameterMappings.size();
        ArrayList parameters = new ArrayList(parameterCount);
        ArrayList overallParameters = new ArrayList(parameterCount + 10);
        boolean hasJoinFetchedCollections = false;
        boolean hasEntityAttributes = false;
        for (int i = 0; i < parameterCount; ++i) {
            AbstractParameterAttribute parameter = parameterMappings.get(i).getParameterAttribute(this, context, embeddableMapping);
            hasJoinFetchedCollections = hasJoinFetchedCollections || parameter.hasJoinFetchedCollections();
            hasEntityAttributes = hasEntityAttributes || parameter.hasJpaManagedAttributes();
            parameters.add(parameter);
            overallParameters.add(parameter);
        }
        this.parameters = Collections.unmodifiableList(parameters);
        for (ManagedViewType<X> subtype : viewType.getOverallInheritanceSubtypeConfiguration().getInheritanceSubtypes()) {
            MappingConstructorImpl constructor;
            if (subtype == this.declaringType || (constructor = (MappingConstructorImpl)subtype.getConstructor(name)) == null) continue;
            overallParameters.addAll(constructor.getParameterAttributes());
        }
        Map<ManagedViewType<X>, String> defaultInheritanceSubtypeConfiguration = viewType.getDefaultInheritanceSubtypeConfiguration().getInheritanceSubtypeConfiguration();
        this.overallInheritanceParametersAttributesClosureConfiguration = new InheritanceSubtypeConstructorConfiguration(this, viewType.getOverallInheritanceSubtypeConfiguration().getInheritanceSubtypeConfiguration().keySet(), overallParameters);
        this.defaultInheritanceParametersAttributesClosureConfiguration = new InheritanceSubtypeConstructorConfiguration(this, defaultInheritanceSubtypeConfiguration.keySet(), this.createParameterAttributesClosure(defaultInheritanceSubtypeConfiguration, context), this.overallInheritanceParametersAttributesClosureConfiguration);
        HashMap inheritanceSubtypeParameterAttributesClosureConfigurations = new HashMap();
        for (Map<ManagedViewType<X>, String> subtypes : viewType.getInheritanceSubtypeConfigurations().keySet()) {
            if (subtypes == viewType.getDefaultInheritanceSubtypeConfiguration()) {
                inheritanceSubtypeParameterAttributesClosureConfigurations.put(subtypes, this.defaultInheritanceParametersAttributesClosureConfiguration);
                continue;
            }
            inheritanceSubtypeParameterAttributesClosureConfigurations.put(subtypes, new InheritanceSubtypeConstructorConfiguration(this, subtypes.keySet(), this.createParameterAttributesClosure(subtypes, context), this.overallInheritanceParametersAttributesClosureConfiguration));
        }
        this.inheritanceSubtypeParameterAttributesClosureConfigurations = Collections.unmodifiableMap(inheritanceSubtypeParameterAttributesClosureConfigurations);
        this.hasJoinFetchedCollections = hasJoinFetchedCollections;
        this.hasEntityAttributes = hasEntityAttributes;
    }

    private List<AbstractParameterAttribute<? super X, ?>> createParameterAttributesClosure(Map<ManagedViewType<? extends X>, String> subtypes, MetamodelBuildingContext context) {
        ArrayList parametersAttributeClosure = new ArrayList(this.parameters.size());
        parametersAttributeClosure.addAll(this.parameters);
        for (ManagedViewType<X> managedViewType : subtypes.keySet()) {
            if (managedViewType == this.declaringType) continue;
            MappingConstructorImpl constructor = (MappingConstructorImpl)managedViewType.getConstructor(this.name);
            if (constructor == null) {
                context.addError("Could not find required mapping constructor with name '" + this.name + "' in inheritance subtype '" + managedViewType.getJavaType().getName() + "'!");
                continue;
            }
            parametersAttributeClosure.addAll(constructor.getParameterAttributes());
        }
        return parametersAttributeClosure;
    }

    public InheritanceSubtypeConstructorConfiguration<X> getSubtypeConstructorConfiguration(Map<ManagedViewType<? extends X>, String> inheritanceSubtypeMappings) {
        if (inheritanceSubtypeMappings == null || inheritanceSubtypeMappings.isEmpty() || this.declaringType.getDefaultInheritanceSubtypeConfiguration().getInheritanceSubtypeConfiguration() == inheritanceSubtypeMappings) {
            return this.defaultInheritanceParametersAttributesClosureConfiguration;
        }
        return this.inheritanceSubtypeParameterAttributesClosureConfigurations.get(inheritanceSubtypeMappings);
    }

    public InheritanceSubtypeConstructorConfiguration<X> getDefaultInheritanceParametersAttributesClosureConfiguration() {
        return this.defaultInheritanceParametersAttributesClosureConfiguration;
    }

    public InheritanceSubtypeConstructorConfiguration<X> getOverallInheritanceParametersAttributesClosureConfiguration() {
        return this.overallInheritanceParametersAttributesClosureConfiguration;
    }

    public Map<Map<ManagedViewType<? extends X>, String>, InheritanceSubtypeConstructorConfiguration<X>> getInheritanceSubtypeParameterAttributesClosureConfigurations() {
        return this.inheritanceSubtypeParameterAttributesClosureConfigurations;
    }

    public void checkParameters(ManagedType<?> managedType, Map<String, List<String>> collectionMappings, Map<String, List<String>> collectionMappingSingulars, MetamodelBuildingContext context) {
        for (AbstractParameterAttribute<X, ?> parameter : this.parameters) {
            parameter.checkAttribute(managedType, context);
            for (Map.Entry<String, Boolean> entry : parameter.getCollectionJoinMappings(managedType, context).entrySet()) {
                List<String> locations;
                if (entry.getValue().booleanValue()) {
                    locations = collectionMappingSingulars.get(entry.getKey());
                    if (locations == null) {
                        locations = new ArrayList<String>(2);
                        collectionMappingSingulars.put(entry.getKey(), locations);
                    }
                    locations.add("Parameter with the index '" + parameter.getIndex() + "' of the constructor '" + parameter.getDeclaringConstructor().getJavaConstructor() + "'");
                    continue;
                }
                locations = collectionMappings.get(entry.getKey());
                if (locations == null) {
                    locations = new ArrayList<String>(2);
                    collectionMappings.put(entry.getKey(), locations);
                }
                locations.add("Parameter with the index '" + parameter.getIndex() + "' of the constructor '" + parameter.getDeclaringConstructor().getJavaConstructor() + "'");
            }
        }
    }

    public void checkNestedParameters(List<AbstractAttribute<?, ?>> parents, ManagedType<?> managedType, MetamodelBuildingContext context, boolean hasMultisetParent) {
        for (AbstractParameterAttribute<X, ?> parameter : this.parameters) {
            parameter.checkNestedAttribute(parents, managedType, context, hasMultisetParent);
        }
    }

    public String getName() {
        return this.name;
    }

    public ManagedViewTypeImplementor<X> getDeclaringType() {
        return this.declaringType;
    }

    public Constructor<X> getJavaConstructor() {
        return this.javaConstructor;
    }

    public List<ParameterAttribute<? super X, ?>> getParameterAttributes() {
        return this.parameters;
    }

    public ParameterAttribute<? super X, ?> getParameterAttribute(int index) {
        return this.parameters.get(index);
    }

    public boolean hasJoinFetchedCollections() {
        return this.hasJoinFetchedCollections;
    }

    public boolean hasEntityAttributes() {
        return this.hasEntityAttributes;
    }

    public static class InheritanceSubtypeConstructorConfiguration<X> {
        private final List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure;
        private final Map<ManagedViewTypeImplementor<? extends X>, int[]> positionAssignments;

        public InheritanceSubtypeConstructorConfiguration(MappingConstructorImpl<X> constructor, Collection<ManagedViewType<? extends X>> managedViewTypes, List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure) {
            this(constructor, managedViewTypes, parameterAttributesClosure, null);
        }

        public InheritanceSubtypeConstructorConfiguration(MappingConstructorImpl<X> constructor, Collection<ManagedViewType<? extends X>> managedViewTypes, List<AbstractParameterAttribute<? super X, ?>> parameterAttributesClosure, InheritanceSubtypeConstructorConfiguration<X> overallConfiguration) {
            this.parameterAttributesClosure = Collections.unmodifiableList(parameterAttributesClosure);
            List<AbstractParameterAttribute<Object, ?>> parameterAttributesClosureToUse = overallConfiguration == null ? parameterAttributesClosure : overallConfiguration.parameterAttributesClosure;
            IdentityHashMap overallPositionMap = new IdentityHashMap(parameterAttributesClosureToUse.size());
            int index = 0;
            for (AbstractParameterAttribute<Object, ?> abstractParameterAttribute : parameterAttributesClosureToUse) {
                overallPositionMap.put(abstractParameterAttribute, index);
                ++index;
            }
            HashMap<ManagedViewTypeImplementor, int[]> positionAssignments = new HashMap<ManagedViewTypeImplementor, int[]>();
            for (ManagedViewType<X> managedViewType : managedViewTypes) {
                MappingConstructor subtypeConstructor = constructor.getDeclaringType() == managedViewType ? constructor : managedViewType.getConstructor(constructor.getName());
                int[] positionAssignment = new int[subtypeConstructor.getParameterAttributes().size()];
                index = 0;
                for (ParameterAttribute parameter : subtypeConstructor.getParameterAttributes()) {
                    positionAssignment[index] = (Integer)overallPositionMap.get(parameter);
                    ++index;
                }
                positionAssignments.put((ManagedViewTypeImplementor)managedViewType, positionAssignment);
            }
            this.positionAssignments = Collections.unmodifiableMap(positionAssignments);
        }

        public List<AbstractParameterAttribute<? super X, ?>> getParameterAttributesClosure() {
            return this.parameterAttributesClosure;
        }

        public int[] getOverallPositionAssignment(ManagedViewTypeImplementor<? extends X> subtype) {
            return this.positionAssignments.get(subtype);
        }
    }
}

