/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class InheritanceViewMapping
implements Comparable<InheritanceViewMapping> {
    private final Map<ViewMapping, String> inheritanceSubtypeMappings;

    public InheritanceViewMapping(ViewMapping baseType, Set<ViewMapping> inheritanceSubtypes) {
        Map<ViewMapping, String> sortedMap = this.createSortedMap();
        sortedMap.put(baseType, null);
        for (ViewMapping subtypeMapping : inheritanceSubtypes) {
            sortedMap.put(subtypeMapping, null);
        }
        this.inheritanceSubtypeMappings = sortedMap;
    }

    public InheritanceViewMapping(Map<ViewMapping, String> inheritanceSubtypeMappings) {
        Map<ViewMapping, String> sortedMap = this.createSortedMap();
        sortedMap.putAll(inheritanceSubtypeMappings);
        this.inheritanceSubtypeMappings = sortedMap;
    }

    private Map<ViewMapping, String> createSortedMap() {
        return new TreeMap<ViewMapping, String>(new Comparator<ViewMapping>(){

            @Override
            public int compare(ViewMapping o1, ViewMapping o2) {
                if (o1.getEntityViewClass() == o2.getEntityViewClass()) {
                    return 0;
                }
                if (o1.getEntityViewClass().isAssignableFrom(o2.getEntityViewClass())) {
                    return -1;
                }
                if (o2.getEntityViewClass().isAssignableFrom(o1.getEntityViewClass())) {
                    return 1;
                }
                return o1.getEntityViewClass().getName().compareTo(o2.getEntityViewClass().getName());
            }
        });
    }

    public Map<ViewMapping, String> getInheritanceSubtypeMappings() {
        return this.inheritanceSubtypeMappings;
    }

    @Override
    public int compareTo(InheritanceViewMapping o) {
        int cmp = Integer.compare(this.inheritanceSubtypeMappings.size(), o.inheritanceSubtypeMappings.size());
        if (cmp != 0) {
            return cmp;
        }
        Iterator<Map.Entry<ViewMapping, String>> firstIter = this.inheritanceSubtypeMappings.entrySet().iterator();
        Iterator<Map.Entry<ViewMapping, String>> secondIter = o.inheritanceSubtypeMappings.entrySet().iterator();
        while (firstIter.hasNext()) {
            Map.Entry<ViewMapping, String> first = firstIter.next();
            Map.Entry<ViewMapping, String> second = secondIter.next();
            cmp = first.getKey().getEntityViewClass().getName().compareTo(second.getKey().getEntityViewClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            if (first.getValue() == null) {
                if (second.getValue() == null) continue;
                return -1;
            }
            if (second.getValue() == null) {
                return 1;
            }
            cmp = first.getValue().compareTo(second.getValue());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InheritanceViewMapping)) {
            return false;
        }
        InheritanceViewMapping that = (InheritanceViewMapping)o;
        return this.getInheritanceSubtypeMappings() != null ? this.getInheritanceSubtypeMappings().equals(that.getInheritanceSubtypeMappings()) : that.getInheritanceSubtypeMappings() == null;
    }

    public int hashCode() {
        return this.getInheritanceSubtypeMappings() != null ? this.getInheritanceSubtypeMappings().hashCode() : 0;
    }
}

