/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.Self;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractParameterAttribute<X, Y>
extends AbstractAttribute<X, Y>
implements ParameterAttribute<X, Y> {
    private final int index;
    private final MappingConstructor<X> declaringConstructor;
    private final boolean selfParameter;

    public AbstractParameterAttribute(MappingConstructorImpl<X> constructor, ParameterAttributeMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        super(constructor.getDeclaringType(), mapping, context, embeddableMapping);
        this.index = mapping.getIndex();
        this.declaringConstructor = constructor;
        this.selfParameter = mapping.getMapping() instanceof Self;
        if (this.selfParameter && !this.getJavaType().isAssignableFrom(this.getDeclaringType().getJavaType())) {
            context.addError("@Self mapping must refer to a view type compatible with the current view type '" + this.getDeclaringType().getJavaType().getName() + "' but was referring to '" + this.getJavaType().getName() + "' at the " + mapping.getErrorLocation());
        }
        if (this.mapping != null && this.mapping.isEmpty()) {
            context.addError("Illegal empty mapping for the " + mapping.getErrorLocation());
        }
    }

    @Override
    protected Class<?>[] getTypeArguments() {
        Class clazz = this.getDeclaringType().getJavaType();
        Constructor constructor = this.getDeclaringConstructor().getJavaConstructor();
        java.lang.reflect.Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        return ReflectionUtils.resolveTypeArguments((Class)clazz, (java.lang.reflect.Type)genericParameterTypes[this.getIndex()]);
    }

    @Override
    public String getLocation() {
        return ParameterAttributeMapping.getLocation(this.declaringConstructor.getJavaConstructor(), this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSelfParameter() {
        return this.selfParameter;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean hasDirtyStateIndex() {
        return false;
    }

    @Override
    public String getMappedBy() {
        return null;
    }

    @Override
    protected boolean isDisallowOwnedUpdatableSubview() {
        return false;
    }

    @Override
    public boolean isUpdateCascaded() {
        return false;
    }

    @Override
    public Set<Type<?>> getUpdateCascadeAllowedSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean needsDirtyTracker() {
        return false;
    }

    public Attribute.MemberType getMemberType() {
        return Attribute.MemberType.PARAMETER;
    }

    @Override
    public Set<Class<?>> getAllowedSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<?>> getParentRequiringUpdateSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<?>> getParentRequiringCreateSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isOptimizeCollectionActionsEnabled() {
        return false;
    }

    public MappingConstructor<X> getDeclaringConstructor() {
        return this.declaringConstructor;
    }
}

