/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.CascadeType;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelUtils;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EntityViewAttributeMapping;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.metamodel.ManagedType;

public abstract class AbstractMethodPluralAttribute<X, C, Y>
extends AbstractMethodAttribute<X, C>
implements PluralAttribute<X, C, Y> {
    private static final Logger LOG = Logger.getLogger(AbstractMethodPluralAttribute.class.getName());
    private final Type<Y> elementType;
    private final PluralAttribute.ElementCollectionType elementCollectionType;
    private final int dirtyStateIndex;
    private final String mappedBy;
    private final Map<String, String> writableMappedByMapping;
    private final InverseRemoveStrategy inverseRemoveStrategy;
    private final boolean updatable;
    private final boolean mutable;
    private final boolean optimisticLockProtected;
    private final boolean persistCascaded;
    private final boolean updateCascaded;
    private final boolean deleteCascaded;
    private final boolean orphanRemoval;
    private final Set<Type<?>> readOnlySubtypes;
    private final Set<Type<?>> persistSubtypes;
    private final Set<Type<?>> updateSubtypes;
    private final Set<Class<?>> allowedSubtypes;
    private final Set<Class<?>> parentRequiringUpdateSubtypes;
    private final Set<Class<?>> parentRequiringCreateSubtypes;
    private final Map<ManagedViewType<? extends Y>, String> elementInheritanceSubtypes;
    private final boolean sorted;
    private final boolean ordered;
    private final Class<Comparator<Object>> comparatorClass;
    private final Comparator<Object> comparator;

    public AbstractMethodPluralAttribute(ManagedViewTypeImplementor<X> viewType, MethodAttributeMapping mapping, MetamodelBuildingContext context, int attributeIndex, int dirtyStateIndex, EmbeddableOwner embeddableMapping) {
        super(viewType, mapping, attributeIndex, context, embeddableMapping);
        Method setter;
        String mappingExpression;
        if (mapping.isId()) {
            context.addError("Attribute annotated with @IdMapping must use a singular type. Plural type found at attribute on the " + mapping.getErrorLocation() + "!");
        }
        if (mapping.isVersion()) {
            context.addError("Attribute annotated with @Version must use a singular type. Plural type found at attribute on the " + mapping.getErrorLocation() + "!");
        }
        this.elementCollectionType = mapping.getElementCollectionType();
        this.elementType = mapping.getElementType(context, embeddableMapping);
        if (mapping.getUpdatable() == null) {
            this.updatable = this.declaringType.isUpdatable() || this.declaringType.isCreatable() ? this.determineUpdatable(this.elementType) : false;
        } else {
            this.updatable = mapping.getUpdatable();
            if (this.updatable && !this.declaringType.isUpdatable() && !this.declaringType.isCreatable()) {
                context.addError("Illegal occurrences of @UpdatableMapping for non-updatable and non-creatable view type '" + this.declaringType.getJavaType().getName() + "' on the " + mapping.getErrorLocation() + "!");
            }
        }
        boolean definesDeleteCascading = mapping.getCascadeTypes().contains(CascadeType.DELETE);
        boolean allowsDeleteCascading = this.updatable || mapping.getCascadeTypes().contains(CascadeType.AUTO);
        this.readOnlySubtypes = mapping.getReadOnlySubtypes(context, embeddableMapping);
        if (this.updatable) {
            Set<Type<Y>> types = this.determinePersistSubtypeSet(this.elementType, mapping.getCascadeSubtypes(context, embeddableMapping), mapping.getCascadePersistSubtypes(context, embeddableMapping), context);
            boolean bl = this.persistCascaded = mapping.getCascadeTypes().contains(CascadeType.PERSIST) || mapping.getCascadeTypes().contains(CascadeType.AUTO) && !types.isEmpty();
            this.persistSubtypes = this.persistCascaded ? types : Collections.emptySet();
        } else {
            this.persistCascaded = false;
            this.persistSubtypes = Collections.emptySet();
        }
        if (mapping.isId() || mapping.isVersion() || !this.declaringType.isUpdatable() && !this.declaringType.isCreatable()) {
            this.updateCascaded = false;
            this.updateSubtypes = Collections.emptySet();
        } else {
            boolean updateCascaded;
            Set<Type<Y>> updateCascadeAllowedSubtypes = this.determineUpdateSubtypeSet(this.elementType, mapping.getCascadeSubtypes(context, embeddableMapping), mapping.getCascadeUpdateSubtypes(context, embeddableMapping), context);
            boolean bl = updateCascaded = mapping.getCascadeTypes().contains(CascadeType.UPDATE) || mapping.getCascadeTypes().contains(CascadeType.AUTO) && !updateCascadeAllowedSubtypes.isEmpty();
            if (updateCascaded) {
                this.updateCascaded = true;
                this.updateSubtypes = updateCascadeAllowedSubtypes;
            } else {
                this.updateCascaded = false;
                this.updateSubtypes = Collections.emptySet();
            }
        }
        this.mutable = this.determineMutable(this.elementType);
        if (!mapping.getCascadeTypes().contains(CascadeType.AUTO) && (this.elementType instanceof BasicType && context.getEntityMetamodel().getEntity(this.elementType.getJavaType()) == null || this.elementType instanceof FlatViewType)) {
            context.addError("Cascading configuration for basic, embeddable or flat view type attributes is not allowed. Invalid definition found on the " + mapping.getErrorLocation() + "!");
        }
        if (!this.updatable && mapping.getCascadeTypes().contains(CascadeType.PERSIST)) {
            context.addError("Persist cascading for non-updatable attributes is not allowed. Invalid definition found on the " + mapping.getErrorLocation() + "!");
        }
        this.allowedSubtypes = this.createAllowedSubtypesSet();
        this.parentRequiringUpdateSubtypes = this.isCorrelated() ? Collections.emptySet() : this.createParentRequiringUpdateSubtypesSet();
        this.parentRequiringCreateSubtypes = this.isCorrelated() ? Collections.emptySet() : this.createParentRequiringCreateSubtypesSet();
        this.optimisticLockProtected = this.determineOptimisticLockProtected(mapping, context, this.mutable);
        this.elementInheritanceSubtypes = mapping.getElementInheritanceSubtypes(context, embeddableMapping);
        this.dirtyStateIndex = this.determineDirtyStateIndex(dirtyStateIndex);
        if (this.dirtyStateIndex == -1) {
            this.mappedBy = null;
            this.inverseRemoveStrategy = null;
            this.writableMappedByMapping = null;
        } else {
            ManagedType managedType;
            String mappingPath;
            if (embeddableMapping == null) {
                mappingPath = this.mapping;
                managedType = context.getEntityMetamodel().getManagedType(this.declaringType.getEntityClass());
            } else {
                mappingPath = embeddableMapping.getEmbeddableMapping() + "." + this.mapping;
                managedType = context.getEntityMetamodel().getManagedType(embeddableMapping.getEntityClass());
            }
            this.mappedBy = mapping.determineMappedBy(managedType, mappingPath, context, embeddableMapping);
            if (this.mappedBy == null) {
                this.inverseRemoveStrategy = null;
                this.writableMappedByMapping = null;
            } else {
                this.inverseRemoveStrategy = mapping.getInverseRemoveStrategy() == null ? InverseRemoveStrategy.SET_NULL : mapping.getInverseRemoveStrategy();
                this.writableMappedByMapping = mapping.determineWritableMappedByMappings(managedType, this.mappedBy, context);
            }
        }
        if (this.inverseRemoveStrategy == null && mapping.getInverseRemoveStrategy() != null && this.dirtyStateIndex != -1) {
            context.addError("Found use of @MappingInverse on attribute that isn't an inverse relationship. Invalid definition found on the " + mapping.getErrorLocation() + "!");
        }
        this.orphanRemoval = Boolean.FALSE.equals(mapping.getOrphanRemoval()) ? false : this.inverseRemoveStrategy == InverseRemoveStrategy.REMOVE || Boolean.TRUE.equals(mapping.getOrphanRemoval());
        boolean bl = this.deleteCascaded = this.orphanRemoval || definesDeleteCascading || allowsDeleteCascading && this.inverseRemoveStrategy != null;
        if (this.updatable && (mappingExpression = this.getMapping()) != null && (this.elementType instanceof BasicType && context.getEntityMetamodel().getEntity(this.elementType.getJavaType()) != null || this.elementType instanceof ViewType)) {
            boolean jpaDeleteCascaded;
            boolean jpaOrphanRemoval = context.getJpaProvider().isOrphanRemoval(this.declaringType.getJpaManagedType(), mappingExpression);
            if (jpaOrphanRemoval && !this.orphanRemoval) {
                context.addError("Orphan removal configuration via @UpdatableMapping must be defined if entity attribute defines orphan removal. Invalid definition found on the  " + mapping.getErrorLocation() + "!");
            }
            if ((jpaDeleteCascaded = context.getJpaProvider().isDeleteCascaded(this.declaringType.getJpaManagedType(), mappingExpression)) && !this.deleteCascaded) {
                context.addError("Delete cascading configuration via @UpdatableMapping must be defined if entity attribute defines delete cascading. Invalid definition found on the  " + mapping.getErrorLocation() + "!");
            }
        }
        if (context.isStrictCascadingCheck() && this.elementType.getMappingType() != Type.MappingType.BASIC && (this.updateCascaded || this.persistCascaded) && (this.declaringType.isUpdatable() || this.declaringType.isCreatable()) && (setter = this.getSetterMethod()) != null) {
            String message = "The setter '" + setter.getName() + "' for the type " + this.declaringType.getJavaType().getName() + " will always produce an exception due to enabled strict cascading checks and should be removed! Use @UpdatableMapping on the getter instead to make this attribute updatable!";
            if (context.isErrorOnInvalidPluralSetter()) {
                context.addError(message);
            } else {
                LOG.warning(message);
            }
        }
        this.sorted = mapping.isSorted();
        this.ordered = mapping.getContainerBehavior() == EntityViewAttributeMapping.ContainerBehavior.ORDERED;
        this.comparatorClass = mapping.getComparatorClass();
        this.comparator = MetamodelUtils.getComparator(this.comparatorClass);
    }

    private boolean determineUpdatable(Type<?> elementType) {
        if (this.getMappingType() != Attribute.MappingType.BASIC && this.getMappingType() != Attribute.MappingType.CORRELATED) {
            return false;
        }
        if (elementType instanceof ManagedViewType) {
            ManagedViewType t = (ManagedViewType)elementType;
            return this.getSetterMethod() != null || t.isCreatable();
        }
        return this.getSetterMethod() != null;
    }

    @Override
    protected boolean isDisallowOwnedUpdatableSubview() {
        return false;
    }

    @Override
    public int getDirtyStateIndex() {
        return this.dirtyStateIndex;
    }

    @Override
    public Map<String, String> getWritableMappedByMappings() {
        return this.writableMappedByMapping;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    public InverseRemoveStrategy getInverseRemoveStrategy() {
        return this.inverseRemoveStrategy;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isOptimisticLockProtected() {
        return this.optimisticLockProtected;
    }

    public boolean isPersistCascaded() {
        return this.persistCascaded;
    }

    @Override
    public boolean isUpdateCascaded() {
        return this.updateCascaded;
    }

    public boolean isDeleteCascaded() {
        return this.deleteCascaded;
    }

    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    public Set<Type<?>> getReadOnlyAllowedSubtypes() {
        return this.readOnlySubtypes;
    }

    public Set<Type<?>> getPersistCascadeAllowedSubtypes() {
        return this.persistSubtypes;
    }

    @Override
    public Set<Type<?>> getUpdateCascadeAllowedSubtypes() {
        return this.updateSubtypes;
    }

    @Override
    public Set<Class<?>> getAllowedSubtypes() {
        return this.allowedSubtypes;
    }

    @Override
    public Set<Class<?>> getParentRequiringUpdateSubtypes() {
        return this.parentRequiringUpdateSubtypes;
    }

    @Override
    public Set<Class<?>> getParentRequiringCreateSubtypes() {
        return this.parentRequiringCreateSubtypes;
    }

    public Attribute.AttributeType getAttributeType() {
        return Attribute.AttributeType.PLURAL;
    }

    @Override
    public Type<Y> getElementType() {
        return this.elementType;
    }

    @Override
    public PluralAttribute.ElementCollectionType getElementCollectionType() {
        return this.elementCollectionType;
    }

    public Map<ManagedViewType<? extends Y>, String> getElementInheritanceSubtypeMappings() {
        return this.elementInheritanceSubtypes;
    }

    @Override
    protected Map<ManagedViewTypeImplementor<?>, String> elementInheritanceSubtypeMappings() {
        return this.elementInheritanceSubtypes;
    }

    public boolean isCollection() {
        return true;
    }

    public boolean isSubview() {
        return this.elementType.getMappingType() != Type.MappingType.BASIC;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Class<Comparator<?>> getComparatorClass() {
        return this.comparatorClass;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }
}

