/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.mapper;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.MacroConfigurationExpressionFactory;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableViewJpqlMacro;
import com.blazebit.persistence.view.impl.mapper.AttributeMapper;
import com.blazebit.persistence.view.impl.mapper.CompositeMapper;
import com.blazebit.persistence.view.impl.mapper.Mapper;
import com.blazebit.persistence.view.impl.mapper.ReferenceViewAttributeMapper;
import com.blazebit.persistence.view.impl.mapper.SimpleMapper;
import com.blazebit.persistence.view.impl.mapper.TargetViewClassBasedMapper;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.update.DefaultEntityTupleizer;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Mappers {
    private Mappers() {
    }

    public static <S, T> Mapper<S, T> targetViewClassBasedMapper(Map<Class<?>, Mapper<S, T>> mapperMap) {
        return new TargetViewClassBasedMapper<S, T>(mapperMap);
    }

    public static <S, T> Mapper<S, T> forAccessor(AttributeAccessor accessor) {
        return new SimpleMapper(accessor);
    }

    public static <S, T> Mapper<S, T> forEntityAttributeMapping(EntityViewManagerImpl evm, Class<S> sourceEntityClass, Class<T> targetEntityClass, Map<String, String> mapping) {
        ArrayList<AttributeAccessor> source = new ArrayList<AttributeAccessor>(mapping.size());
        ArrayList<AttributeAccessor> target = new ArrayList<AttributeAccessor>(mapping.size());
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            source.add(Accessors.forEntityMapping(evm, sourceEntityClass, entry.getKey()));
            target.add(Accessors.forEntityMapping(evm, targetEntityClass, entry.getValue()));
        }
        return new AttributeMapper(source, target);
    }

    public static <S, T> Mapper<S, T> forViewAttributeMapping(EntityViewManagerImpl evm, ManagedViewType<S> sourceViewType, ManagedViewType<T> targetViewType, Map<String, String> mapping) {
        ArrayList<AttributeAccessor> source = new ArrayList<AttributeAccessor>(mapping.size());
        ArrayList<AttributeAccessor> target = new ArrayList<AttributeAccessor>(mapping.size());
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            source.add(Accessors.forViewAttributePath(evm, sourceViewType, entry.getKey(), true));
            target.add(Accessors.forViewAttributePath(evm, targetViewType, entry.getValue(), false));
        }
        return new AttributeMapper(source, target);
    }

    public static <S, T> Mapper<S, T> forViewToEntityAttributeMapping(EntityViewManagerImpl evm, ManagedViewType<S> sourceViewType, Class<T> targetEntityClass) {
        Set attributes = sourceViewType.getAttributes();
        HashMap<String, String> mappings = new HashMap<String, String>(attributes.size());
        Mappers.buildViewToEntityMappings("", "", attributes, mappings);
        return Mappers.forViewToEntityAttributeMapping(evm, sourceViewType, targetEntityClass, mappings);
    }

    private static void buildViewToEntityMappings(String attributePrefix, String mappingPrefix, Set<MethodAttribute<?, ?>> attributes, Map<String, String> mappings) {
        for (MethodAttribute<?, ?> attribute : attributes) {
            if (!(attribute instanceof SingularAttribute)) {
                throw new IllegalArgumentException("Plural attributes aren't supported yet for view to entity mappings!");
            }
            SingularAttribute attr = (SingularAttribute)attribute;
            if (attr.getType() instanceof BasicType) {
                mappings.put(attributePrefix + attribute.getName(), mappingPrefix + ((MappingAttribute)attr).getMapping());
                continue;
            }
            ManagedViewType viewType = (ManagedViewType)attr.getType();
            Mappers.buildViewToEntityMappings(attributePrefix + attribute.getName() + ".", mappingPrefix + ((MappingAttribute)attr).getMapping() + ".", viewType.getAttributes(), mappings);
        }
    }

    public static <S, T> Mapper<S, T> forViewToEntityAttributeMapping(EntityViewManagerImpl evm, ManagedViewType<S> sourceViewType, Class<T> targetEntityClass, Map<String, String> mapping) {
        EntityMetamodel metamodel = (EntityMetamodel)evm.getCriteriaBuilderFactory().getService(EntityMetamodel.class);
        ArrayList<AttributeAccessor> source = new ArrayList<AttributeAccessor>(mapping.size());
        ArrayList<AttributeAccessor> target = new ArrayList<AttributeAccessor>(mapping.size());
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            source.add(Accessors.forViewAttributePath(evm, sourceViewType, entry.getKey(), true));
            target.add(Accessors.forEntityMapping(evm, targetEntityClass, entry.getValue()));
        }
        return new AttributeMapper(source, target);
    }

    public static <S, T> Mapper<S, T> forEntityAttributeMappingConvertToViewAttributeMapping(EntityViewManagerImpl evm, Class<S> sourceEntityClass, ManagedViewType<T> targetViewType, Map<String, String> mapping) {
        ArrayList<AttributeAccessor> source = new ArrayList<AttributeAccessor>(mapping.size());
        ArrayList<AttributeAccessor> target = new ArrayList<AttributeAccessor>(mapping.size());
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            source.add(Accessors.forEntityMapping(evm, sourceEntityClass, entry.getKey()));
            AttributeAccessor attributeAccessor = Accessors.forEntityMappingAsViewAccessor(evm, targetViewType, entry.getValue(), false);
            if (attributeAccessor == null) {
                return null;
            }
            target.add(attributeAccessor);
        }
        return new AttributeMapper(source, target);
    }

    public static <S, T> Mapper<S, T> forViewConvertToViewAttributeMapping(EntityViewManagerImpl evm, ViewType<S> sourceViewType, ViewType<T> targetViewType, String mappedBy, Mapper<S, T> additionalMapper) {
        ArrayList<Mapper<S, T>> mappers = new ArrayList<Mapper<S, T>>();
        AttributeAccessor entityAccessor = Accessors.forEntityMapping(evm, sourceViewType.getEntityClass(), ((MappingAttribute)sourceViewType.getIdAttribute()).getMapping());
        ExpressionFactory ef = (ExpressionFactory)evm.getCriteriaBuilderFactory().getService(ExpressionFactory.class);
        for (MethodAttribute attribute : targetViewType.getAttributes()) {
            if (!attribute.isUpdatable() || !(attribute instanceof MappingAttribute) || !(attribute instanceof SingularAttribute) || !mappedBy.equals(((MappingAttribute)attribute).getMapping())) continue;
            ViewType attributeType = (ViewType)((SingularAttribute)attribute).getType();
            Type attributeViewIdType = ((SingularAttribute)attributeType.getIdAttribute()).getType();
            DefaultEntityTupleizer entityTupleizer = null;
            ObjectBuilder<?> idViewBuilder = null;
            if (attributeViewIdType instanceof ManagedViewType) {
                entityTupleizer = new DefaultEntityTupleizer(evm, (ManagedViewType)attributeViewIdType);
                idViewBuilder = evm.getTemplate(new MacroConfigurationExpressionFactory(ef, ef.getDefaultMacroConfiguration()), (ManagedViewTypeImplementor)attributeViewIdType, null, null, new MutableViewJpqlMacro(), null, new MutableEmbeddingViewJpqlMacro(), 0).createObjectBuilder(null, null, null, 0, false, false);
            }
            mappers.add(new ReferenceViewAttributeMapper(evm, entityAccessor, attributeType.getJavaType(), entityTupleizer, Accessors.forMutableViewAttribute(evm, attribute), idViewBuilder));
        }
        if (mappers.isEmpty()) {
            return additionalMapper;
        }
        if (additionalMapper != null) {
            mappers.add(additionalMapper);
        }
        return new CompositeMapper(mappers.toArray(new Mapper[mappers.size()]));
    }

    public static <S, T> Mapper<S, T> forViewConvertToViewAttributeMapping(EntityViewManagerImpl evm, ViewType<S> sourceViewType, ViewType<T> targetViewType, Map<String, String> mapping, Mapper<S, T> additionalMapper) {
        ArrayList mappers = new ArrayList();
        ExpressionFactory ef = (ExpressionFactory)evm.getCriteriaBuilderFactory().getService(ExpressionFactory.class);
        for (MethodAttribute attribute : targetViewType.getAttributes()) {
            if (!attribute.isUpdatable() || !(attribute instanceof MappingAttribute) || !(attribute instanceof SingularAttribute)) continue;
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                if (!entry.getValue().equals(((MappingAttribute)attribute).getMapping())) continue;
                Type attributeType = ((SingularAttribute)attribute).getType();
                AttributeAccessor entityAccessor = entry.getKey().isEmpty() ? Accessors.forEntityMapping(evm, sourceViewType.getEntityClass(), ((MappingAttribute)sourceViewType.getIdAttribute()).getMapping()) : Accessors.forEntityMapping(evm, sourceViewType.getEntityClass(), entry.getKey());
                InitialValueAttributeAccessor targetAttributeAccessor = Accessors.forMutableViewAttribute(evm, attribute);
                if (attributeType instanceof ViewType) {
                    ViewType viewType = (ViewType)attributeType;
                    Type attributeViewIdType = ((SingularAttribute)viewType.getIdAttribute()).getType();
                    DefaultEntityTupleizer entityTupleizer = null;
                    ObjectBuilder<?> idViewBuilder = null;
                    if (attributeViewIdType instanceof ManagedViewType) {
                        entityTupleizer = new DefaultEntityTupleizer(evm, (ManagedViewType)attributeViewIdType);
                        idViewBuilder = evm.getTemplate(new MacroConfigurationExpressionFactory(ef, ef.getDefaultMacroConfiguration()), (ManagedViewTypeImplementor)attributeViewIdType, null, null, new MutableViewJpqlMacro(), null, new MutableEmbeddingViewJpqlMacro(), 0).createObjectBuilder(null, null, null, 0, false, false);
                    }
                    mappers.add(new ReferenceViewAttributeMapper(evm, entityAccessor, viewType.getJavaType(), entityTupleizer, targetAttributeAccessor, idViewBuilder));
                    continue;
                }
                mappers.add(new AttributeMapper(Collections.singletonList(entityAccessor), Collections.singletonList(targetAttributeAccessor)));
            }
        }
        if (mappers.isEmpty()) {
            return additionalMapper;
        }
        return new CompositeMapper(mappers.toArray(new Mapper[mappers.size()]));
    }
}

