/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;

public class FullEntityLoader
extends AbstractEntityLoader {
    private final String queryString;
    private final String queryStringMultiple;

    public FullEntityLoader(EntityViewManagerImpl evm, ManagedViewType<?> subviewType) {
        super(evm, subviewType.getEntityClass(), FullEntityLoader.jpaIdOf(evm, subviewType), FullEntityLoader.viewIdMappingOf(evm, subviewType), null, evm.getEntityIdAccessor());
        this.queryString = this.createQueryString(evm, subviewType, false);
        this.queryStringMultiple = this.createQueryString(evm, subviewType, true);
    }

    private String createQueryString(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, boolean multiple) {
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        EntityType entityType = entityMetamodel.getEntity(this.entityClass);
        if (entityType == null) {
            return null;
        }
        HashSet<String> fetchJoinableRelations = new HashSet<String>(subviewType.getAttributes().size());
        this.addFetchJoinableRelations(fetchJoinableRelations, "", subviewType);
        CriteriaBuilderFactory cbf = evm.getCriteriaBuilderFactory();
        if (fetchJoinableRelations.isEmpty()) {
            return null;
        }
        CriteriaBuilder criteriaBuilder = (CriteriaBuilder)cbf.create(null, this.entityClass).fetch(fetchJoinableRelations.toArray(new String[fetchJoinableRelations.size()]));
        if (multiple) {
            criteriaBuilder.where(JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)entityType).getName()).inExpressions(new String[]{":entityIds"});
        } else {
            criteriaBuilder.where(JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)entityType).getName()).eqExpression(":id");
        }
        return criteriaBuilder.getQueryString();
    }

    private void addFetchJoinableRelations(Set<String> fetchJoinableRelations, String prefix, ManagedViewType<?> subviewType) {
        Set attributes = subviewType.getAttributes();
        for (MethodAttribute attribute : attributes) {
            ManagedViewType type;
            String mapping;
            if (attribute.getMappingType() != Attribute.MappingType.BASIC) continue;
            if (attribute.isUpdatable()) {
                mapping = this.getMapping(prefix, attribute);
                fetchJoinableRelations.add(mapping);
            }
            if (!attribute.isMutable() || !attribute.isSubview()) continue;
            mapping = this.getMapping(prefix, attribute);
            fetchJoinableRelations.add(mapping);
            if (attribute instanceof SingularAttribute) {
                type = (ManagedViewType)((SingularAttribute)attribute).getType();
            } else if (attribute instanceof PluralAttribute) {
                type = (ManagedViewType)((PluralAttribute)attribute).getElementType();
            } else {
                throw new RuntimeException("Unknown attribute type: " + attribute);
            }
            this.addFetchJoinableRelations(fetchJoinableRelations, mapping + ".", type);
        }
    }

    private String getMapping(String prefix, MethodAttribute<?, ?> attribute) {
        String mapping = ((MappingAttribute)attribute).getMapping();
        return prefix + mapping.replaceAll("\\[[^\\]]\\]", "");
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null || this.entityIdAccessor == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    public void toEntities(UpdateContext context, List<Object> views, List<Object> ids) {
        if (this.entityIdAccessor == null) {
            for (int i = 0; i < views.size(); ++i) {
                views.set(i, this.createEntity());
            }
        } else {
            this.getReferencesLoadOrCreate(context, views, ids);
        }
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        if (this.queryString == null) {
            return em.find(this.entityClass, id);
        }
        List list = em.createQuery(this.queryString).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        return list.get(0);
    }

    @Override
    protected List<Object> queryEntities(EntityManager em, List<Object> ids) {
        List list = em.createQuery(this.queryStringMultiple).setParameter("entityIds", ids).getResultList();
        if (list.size() != ids.size()) {
            throw new EntityNotFoundException("Required entities '" + this.entityClass.getName() + "' with ids '" + ids + "' couldn't all be found!");
        }
        return list;
    }
}

