/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionAddAllAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveAllAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class CollectionOperations {
    private final List<? extends CollectionAction<? extends Collection<?>>> actions;
    private final CollectionRemoveAllAction removeAction;
    private final CollectionAddAllAction addAction;
    private final int removeIndex;

    public CollectionOperations(List<? extends CollectionAction<? extends Collection<?>>> actions) {
        CollectionRemoveAllAction removeAction = null;
        CollectionAddAllAction addAction = null;
        int removeIndex = actions.size();
        if (!actions.isEmpty()) {
            CollectionAction<Collection<?>> a = actions.get(actions.size() - 1);
            if (a instanceof CollectionRemoveAllAction) {
                removeAction = (CollectionRemoveAllAction)a;
                removeIndex = actions.size() - 1;
            } else if (a instanceof CollectionAddAllAction) {
                addAction = (CollectionAddAllAction)a;
                removeIndex = actions.size() - 1;
                if (actions.size() > 1 && (a = actions.get(actions.size() - 2)) instanceof CollectionRemoveAllAction) {
                    removeAction = (CollectionRemoveAllAction)a;
                    removeIndex = actions.size() - 2;
                }
            }
        }
        this.actions = actions;
        this.removeAction = removeAction;
        this.addAction = addAction;
        this.removeIndex = removeIndex;
    }

    public boolean addElements(RecordingCollection<?, ?> recordingCollection, Collection<Object> addedElements) {
        if (!addedElements.isEmpty()) {
            Collection<Object> objectsToAdd = addedElements;
            if (this.removeAction != null) {
                objectsToAdd = this.removeAction.onAddObjects(objectsToAdd);
            }
            if (!objectsToAdd.isEmpty() && this.addAction != null) {
                this.addAction.onAddObjects(objectsToAdd);
                return false;
            }
            if (addedElements != objectsToAdd) {
                Iterator<Object> iterator = addedElements.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (objectsToAdd.contains(o)) continue;
                    iterator.remove();
                    recordingCollection.addAddedElement(o);
                }
            }
            return !objectsToAdd.isEmpty();
        }
        return false;
    }

    public int removeElements(RecordingCollection<?, ?> recordingCollection, Collection<Object> removedElements) {
        if (!removedElements.isEmpty()) {
            Collection<Object> objectsToRemove = removedElements;
            if (this.addAction != null) {
                objectsToRemove = this.addAction.onRemoveObjects(objectsToRemove);
            }
            if (!objectsToRemove.isEmpty()) {
                if (this.removeAction != null) {
                    this.removeAction.onRemoveObjects(objectsToRemove);
                } else {
                    if (removedElements != objectsToRemove) {
                        Iterator<Object> iterator = removedElements.iterator();
                        while (iterator.hasNext()) {
                            Object o = iterator.next();
                            if (objectsToRemove.contains(o)) continue;
                            iterator.remove();
                            recordingCollection.addRemovedElement(o);
                        }
                    }
                    return this.removeIndex;
                }
            }
        }
        return -1;
    }

    public void removeEmpty() {
        if (this.addAction != null && this.addAction.isEmpty()) {
            this.actions.remove(this.actions.size() - 1);
        }
        if (this.removeAction != null && this.removeAction.isEmpty()) {
            this.actions.remove(this.removeIndex);
        }
    }
}

