/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import java.util.Map;
import java.util.Set;

public class StaticCorrelationProvider
implements CorrelationProvider,
CorrelationProviderFactory {
    private final Class<?> correlated;
    private final String correlationKeyAlias;
    private final int approximateExpressionSize;
    private final Predicate correlationPredicate;
    private final Set<String> rootAliases;

    public StaticCorrelationProvider(Class<?> correlated, String correlationKeyAlias, String correlationExpression, Predicate correlationPredicate, Set<String> rootAliases) {
        this.correlated = correlated;
        this.correlationKeyAlias = correlationKeyAlias;
        this.approximateExpressionSize = correlationExpression.length() * 2;
        this.correlationPredicate = correlationPredicate;
        this.rootAliases = rootAliases;
    }

    public boolean isParameterized() {
        return false;
    }

    public CorrelationProvider create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters) {
        return this;
    }

    public Predicate getCorrelationPredicate() {
        return this.correlationPredicate;
    }

    public void applyCorrelation(CorrelationBuilder correlationBuilder, String correlationExpression) {
        String alias = correlationBuilder.getCorrelationAlias();
        ExpressionFactory expressionFactory = (ExpressionFactory)correlationBuilder.getService(ExpressionFactory.class);
        PrefixingQueryGenerator prefixingQueryGenerator = new PrefixingQueryGenerator(expressionFactory, alias, correlationExpression, this.correlationKeyAlias, this.rootAliases, true, false);
        StringBuilder sb = new StringBuilder(this.approximateExpressionSize);
        prefixingQueryGenerator.setQueryBuffer(sb);
        this.correlationPredicate.accept((Expression.Visitor)prefixingQueryGenerator);
        String finalExpression = sb.toString();
        ((JoinOnBuilder)correlationBuilder.correlate(this.correlated).onExpression(finalExpression)).end();
    }
}

