/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.spi.JpqlFunction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.NClob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;

public class ScalarTargetResolvingExpressionVisitor
extends PathTargetResolvingExpressionVisitor {
    private static final Map<Class<?>, TypeKind> TYPE_KINDS;
    private final ManagedType<?> managedType;
    private final Map<String, JpqlFunction> functions;
    private boolean parametersAllowed;

    public ScalarTargetResolvingExpressionVisitor(Class<?> managedType, EntityMetamodel metamodel, Map<String, JpqlFunction> functions, Map<String, Type<?>> rootTypes) {
        this(metamodel.managedType(managedType), metamodel, functions, rootTypes);
    }

    public ScalarTargetResolvingExpressionVisitor(ManagedType<?> managedType, EntityMetamodel metamodel, Map<String, JpqlFunction> functions, Map<String, Type<?>> rootTypes) {
        this(managedType, null, metamodel, functions, rootTypes);
    }

    public ScalarTargetResolvingExpressionVisitor(ManagedType<?> managedType, Attribute<?, ?> rootAttribute, EntityMetamodel metamodel, Map<String, JpqlFunction> functions, Map<String, Type<?>> rootTypes) {
        super(metamodel, managedType, rootAttribute, null, rootTypes);
        this.managedType = managedType;
        this.functions = functions;
        this.parametersAllowed = false;
    }

    public List<TargetType> getPossibleTargetTypes() {
        List positions = this.pathPositions;
        int size = positions.size();
        ArrayList<TargetType> possibleTargets = new ArrayList<TargetType>(size);
        for (int i = 0; i < size; ++i) {
            PathTargetResolvingExpressionVisitor.PathPosition position = (PathTargetResolvingExpressionVisitor.PathPosition)positions.get(i);
            if (position.getCurrentClass() == null) continue;
            possibleTargets.add(new TargetTypeImpl(position.hasCollectionJoin(), position.getAttribute(), position.getRealCurrentClass(), position.getKeyCurrentClass(), position.getCurrentClass()));
        }
        return possibleTargets;
    }

    public void visit(GeneralCaseExpression expression) {
        this.visit(expression, this.metamodel.type(Boolean.class));
    }

    private void visit(GeneralCaseExpression expression, Type<?> conditionType) {
        List currentPositions = this.pathPositions;
        ArrayList<PathTargetResolvingExpressionVisitor.PathPosition> newPositions = new ArrayList<PathTargetResolvingExpressionVisitor.PathPosition>();
        int positionsSize = currentPositions.size();
        for (int j = 0; j < positionsSize; ++j) {
            List expressions = expression.getWhenClauses();
            int size = expressions.size();
            block1: for (int i = 0; i < size; ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
                this.pathPositions = new ArrayList();
                this.currentPosition = position;
                this.pathPositions.add(this.currentPosition);
                PathTargetResolvingExpressionVisitor.PathPosition pathPosition = this.resolve(((WhenClauseExpression)expressions.get(i)).getCondition());
                if (conditionType != null && pathPosition != null && pathPosition.getCurrentType() != null && !this.isCompatible(conditionType, pathPosition.getCurrentType())) {
                    this.invalid(expression, "The case predicate compares different types: [" + conditionType.getJavaType().getName() + ", " + ScalarTargetResolvingExpressionVisitor.typeName(pathPosition) + "]");
                }
                ((WhenClauseExpression)expressions.get(i)).getResult().accept((Expression.Visitor)this);
                for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                    if (newPosition.getCurrentClass() == null) continue;
                    newPositions.add(newPosition);
                    break block1;
                }
            }
            if (!newPositions.isEmpty() || expression.getDefaultExpr() == null) continue;
            PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
            this.pathPositions = new ArrayList();
            this.currentPosition = position;
            this.pathPositions.add(this.currentPosition);
            expression.getDefaultExpr().accept((Expression.Visitor)this);
            for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                if (newPosition.getCurrentClass() == null) continue;
                newPositions.add(newPosition);
            }
        }
        if (newPositions.isEmpty()) {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(null);
        } else {
            this.currentPosition = (PathTargetResolvingExpressionVisitor.PathPosition)newPositions.get(0);
        }
        this.pathPositions = newPositions;
    }

    public void visit(ArrayExpression expression) {
        if (expression.getBase() instanceof EntityLiteral) {
            this.currentPosition.setCurrentType((Type)this.metamodel.entity(((EntityLiteral)expression.getBase()).getValue()));
        } else {
            expression.getBase().accept((Expression.Visitor)this);
            this.currentPosition.setCurrentType(this.currentPosition.getCurrentType());
        }
        boolean wasParamsAllowed = this.parametersAllowed;
        List currentPositions = this.pathPositions;
        PathTargetResolvingExpressionVisitor.PathPosition position = this.currentPosition;
        this.parametersAllowed = true;
        this.pathPositions = new ArrayList();
        if (expression.getIndex() instanceof Predicate) {
            this.currentPosition = this.currentPosition.copy();
            this.pathPositions.add(this.currentPosition);
        } else {
            this.currentPosition = new PathTargetResolvingExpressionVisitor.PathPosition(this.managedType, null);
            this.pathPositions.add(this.currentPosition);
        }
        expression.getIndex().accept((Expression.Visitor)this);
        this.parametersAllowed = wasParamsAllowed;
        this.currentPosition = position;
        this.pathPositions = currentPositions;
    }

    public void visit(TreatExpression expression) {
        EntityType type = this.metamodel.getEntity(expression.getType());
        if (type == null) {
            throw new RuntimeException("No entity found with name \"" + expression.getType() + "\"");
        }
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType((Type)type);
    }

    public void visit(ParameterExpression expression) {
        if (this.parametersAllowed) {
            this.currentPosition.setCurrentType(null);
        } else {
            for (PathTargetResolvingExpressionVisitor.PathPosition position : this.pathPositions) {
                if (position == this.currentPosition || position.getCurrentClass() == null) continue;
                this.currentPosition.setCurrentType(null);
                return;
            }
            this.invalid(expression, "Parameters are not allowed as results in mapping. Please use @MappingParameter for this instead!");
        }
    }

    public void visit(NullExpression expression) {
        this.currentPosition.setCurrentType(null);
    }

    public void visit(ArithmeticExpression expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        } else {
            PathTargetResolvingExpressionVisitor.PathPosition left = this.resolve(expression.getLeft());
            PathTargetResolvingExpressionVisitor.PathPosition right = this.resolve(expression.getRight());
            if (left == null) {
                if (right == null) {
                    this.currentPosition.setCurrentType(null);
                } else {
                    this.currentPosition.setCurrentType(right.getCurrentType());
                }
            } else if (left.getCurrentType() == null || left.getCurrentType() == right.getCurrentType()) {
                this.currentPosition.setCurrentType(right.getCurrentType());
            } else {
                this.currentPosition.setCurrentType(left.getCurrentType());
            }
        }
    }

    public void visit(ArithmeticFactor expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        } else {
            expression.getExpression().accept((Expression.Visitor)this);
        }
    }

    public void visit(NumericLiteral expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        } else {
            this.currentPosition.setCurrentType(null);
        }
    }

    public void visit(BooleanLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(StringLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(String.class));
    }

    public void visit(DateLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(TimeLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(TimestampLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(SubqueryExpression expression) {
        this.invalid(expression);
    }

    public void visit(ListIndexExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof ListAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.List!");
        } else {
            this.currentPosition.setAttribute((Attribute)new ListIndexAttribute((ListAttribute)this.currentPosition.getAttribute()));
            this.currentPosition.setCurrentType(this.metamodel.type(Integer.class));
        }
    }

    public void visit(MapEntryExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(this.metamodel.type(Map.Entry.class));
        }
    }

    public void visit(MapKeyExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            MapKeyAttribute keyAttribute = new MapKeyAttribute((MapAttribute)this.currentPosition.getAttribute());
            this.currentPosition.setAttribute((Attribute)keyAttribute);
            this.currentPosition.setCurrentType(keyAttribute.getType());
        }
    }

    public void visit(MapValueExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            this.currentPosition.setCurrentType(this.currentPosition.getCurrentType());
        }
    }

    public void visit(FunctionExpression expression) {
        String name;
        switch (name = expression.getFunctionName().toLowerCase()) {
            case "function": {
                String functionName = ((StringLiteral)expression.getExpressions().get(0)).getValue();
                JpqlFunction jpqlFunction = this.functions.get(functionName.toLowerCase());
                if (jpqlFunction == null) {
                    this.currentPosition.setAttribute(null);
                    this.currentPosition.setCurrentType(null);
                    break;
                }
                this.resolveFirst(expression.getExpressions().subList(1, expression.getExpressions().size()), true);
                this.resolveToFunctionReturnType(functionName);
                break;
            }
            case "size": {
                this.currentPosition.setAttribute(null);
                this.currentPosition.setCurrentType(this.metamodel.type(Long.class));
                break;
            }
            case "coalesce": {
                this.resolveAny(expression.getExpressions(), true);
                this.resolveToFunctionReturnType(name);
                break;
            }
            default: {
                this.resolveFirst(expression.getExpressions(), true);
                this.resolveToFunctionReturnType(name);
            }
        }
    }

    private void resolveAny(List<Expression> expressions, boolean allowParams) {
        List currentPositions = this.pathPositions;
        ArrayList<PathTargetResolvingExpressionVisitor.PathPosition> newPositions = new ArrayList<PathTargetResolvingExpressionVisitor.PathPosition>();
        int positionsSize = currentPositions.size();
        int expressionsSize = expressions.size();
        PathTargetResolvingExpressionVisitor.PathPosition resolvedPosition = null;
        block0: for (int j = 0; j < positionsSize; ++j) {
            for (int i = 0; i < expressionsSize; ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
                this.pathPositions = new ArrayList();
                this.currentPosition = position;
                this.pathPositions.add(this.currentPosition);
                if (allowParams) {
                    this.parametersAllowed = true;
                }
                if (expressions.isEmpty()) {
                    position.setCurrentType(null);
                    position.setAttribute(null);
                } else {
                    expressions.get(i).accept((Expression.Visitor)this);
                }
                if (allowParams) {
                    this.parametersAllowed = false;
                }
                for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                    if (newPosition.getCurrentClass() == null) continue;
                    if (resolvedPosition == null) {
                        resolvedPosition = newPosition;
                    }
                    newPositions.add(newPosition);
                    continue block0;
                }
            }
            newPositions.add(new PathTargetResolvingExpressionVisitor.PathPosition(null, null));
        }
        if (resolvedPosition == null) {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(null);
        } else {
            this.currentPosition = resolvedPosition;
        }
        this.pathPositions = newPositions;
    }

    private void resolveFirst(List<Expression> expressions, boolean allowParams) {
        List currentPositions = this.pathPositions;
        ArrayList<PathTargetResolvingExpressionVisitor.PathPosition> newPositions = new ArrayList<PathTargetResolvingExpressionVisitor.PathPosition>();
        int positionsSize = currentPositions.size();
        block0: for (int j = 0; j < positionsSize; ++j) {
            PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
            this.pathPositions = new ArrayList();
            this.currentPosition = position;
            this.pathPositions.add(this.currentPosition);
            if (allowParams) {
                this.parametersAllowed = true;
            }
            if (expressions.isEmpty()) {
                position.setCurrentType(null);
                position.setAttribute(null);
            } else {
                expressions.get(0).accept((Expression.Visitor)this);
            }
            if (allowParams) {
                this.parametersAllowed = false;
            }
            for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                if (newPosition.getCurrentClass() == null) continue;
                newPositions.add(newPosition);
                continue block0;
            }
            newPositions.add(new PathTargetResolvingExpressionVisitor.PathPosition(null, null));
        }
        if (newPositions.isEmpty()) {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(null);
        } else {
            this.currentPosition = (PathTargetResolvingExpressionVisitor.PathPosition)newPositions.get(0);
        }
        this.pathPositions = newPositions;
    }

    private void resolveToFunctionReturnType(String functionName) {
        JpqlFunction function = this.functions.get(functionName.toLowerCase());
        List currentPositions = this.pathPositions;
        int positionsSize = currentPositions.size();
        if (function == null) {
            if (positionsSize == 0) {
                currentPositions.add(new PathTargetResolvingExpressionVisitor.PathPosition(null, null));
            } else {
                for (int i = 0; i < positionsSize; ++i) {
                    PathTargetResolvingExpressionVisitor.PathPosition position = (PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(i);
                    position.setAttribute(null);
                    position.setCurrentType(null);
                }
            }
        } else if (positionsSize == 0) {
            Class returnType = function.getReturnType(null);
            currentPositions.add(new PathTargetResolvingExpressionVisitor.PathPosition(returnType == null ? null : this.metamodel.type(returnType), null));
        } else {
            for (int i = 0; i < positionsSize; ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition position = (PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(i);
                Class returnType = function.getReturnType(position.getCurrentClass());
                position.setAttribute(null);
                position.setCurrentType(returnType == null ? null : this.metamodel.type(returnType));
            }
        }
    }

    public void visit(TrimExpression expression) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(String.class));
    }

    public void visit(SimpleCaseExpression expression) {
        PathTargetResolvingExpressionVisitor.PathPosition pathPosition = this.resolve(expression.getCaseOperand());
        this.visit((GeneralCaseExpression)expression, pathPosition == null ? null : pathPosition.getCurrentType());
    }

    public void visit(WhenClauseExpression expression) {
        this.invalid(expression, "Should be handled by case expression");
    }

    public void visit(EnumLiteral expression) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(expression.getValue().getDeclaringClass()));
    }

    public void visit(EntityLiteral expression) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(EntityType.class));
    }

    public void visit(TypeFunctionExpression expression) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(EntityType.class));
    }

    public void visit(CompoundPredicate predicate) {
        List children = predicate.getChildren();
        PathTargetResolvingExpressionVisitor.PathPosition position = this.currentPosition;
        List currentPositions = this.pathPositions;
        for (int i = 0; i < children.size(); ++i) {
            this.pathPositions = new ArrayList();
            this.currentPosition = position.copy();
            this.pathPositions.add(this.currentPosition);
            ((Predicate)children.get(i)).accept((Expression.Visitor)this);
        }
        this.pathPositions = currentPositions;
        this.currentPosition = position;
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(EqPredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(GtPredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(GePredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(LtPredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(LePredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(MemberOfPredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(LikePredicate predicate) {
        this.visit((BinaryExpressionPredicate)predicate);
    }

    public void visit(BinaryExpressionPredicate predicate) {
        PathTargetResolvingExpressionVisitor.PathPosition left = this.resolve(predicate.getLeft());
        PathTargetResolvingExpressionVisitor.PathPosition right = this.resolve(predicate.getRight());
        if (left != null && right != null && left.getCurrentType() != null && right.getCurrentType() != null && !this.isCompatible(left.getCurrentType(), right.getCurrentType())) {
            this.invalid(predicate, "The binary predicate compares different types: [" + ScalarTargetResolvingExpressionVisitor.typeName(left) + ", " + ScalarTargetResolvingExpressionVisitor.typeName(right) + "]");
        }
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    private PathTargetResolvingExpressionVisitor.PathPosition resolve(Expression expression) {
        boolean wasParamsAllowed = this.parametersAllowed;
        List currentPositions = this.pathPositions;
        PathTargetResolvingExpressionVisitor.PathPosition position = this.currentPosition;
        this.parametersAllowed = true;
        this.pathPositions = new ArrayList();
        this.currentPosition = this.currentPosition.copy();
        this.pathPositions.add(this.currentPosition);
        expression.accept((Expression.Visitor)this);
        PathTargetResolvingExpressionVisitor.PathPosition expressionPathPosition = this.currentPosition;
        this.parametersAllowed = wasParamsAllowed;
        this.currentPosition = position;
        this.pathPositions = currentPositions;
        return expressionPathPosition;
    }

    public void visit(IsNullPredicate predicate) {
        predicate.getExpression().accept((Expression.Visitor)this);
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(IsEmptyPredicate predicate) {
        predicate.getExpression().accept((Expression.Visitor)this);
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(BetweenPredicate predicate) {
        PathTargetResolvingExpressionVisitor.PathPosition left = this.resolve(predicate.getLeft());
        PathTargetResolvingExpressionVisitor.PathPosition start = this.resolve(predicate.getStart());
        PathTargetResolvingExpressionVisitor.PathPosition end = this.resolve(predicate.getEnd());
        if (!(left == null || start == null || end == null || left.getCurrentType() == null || start.getCurrentType() == null || end.getCurrentType() == null || this.isCompatible(left.getCurrentType(), start.getCurrentType()) && this.isCompatible(left.getCurrentType(), end.getCurrentType()))) {
            this.invalid(predicate, "The between predicate compares different types: [" + ScalarTargetResolvingExpressionVisitor.typeName(left) + ", " + ScalarTargetResolvingExpressionVisitor.typeName(start) + ", " + ScalarTargetResolvingExpressionVisitor.typeName(end) + "]");
        }
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(InPredicate predicate) {
        PathTargetResolvingExpressionVisitor.PathPosition left = this.resolve(predicate.getLeft());
        List expressions = predicate.getRight();
        ArrayList<String> expressionTypes = new ArrayList<String>(expressions.size());
        if (left != null && left.getCurrentType() != null) {
            boolean invalid = false;
            for (int i = 0; i < expressions.size(); ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition pathPosition = this.resolve((Expression)expressions.get(i));
                if (pathPosition == null) continue;
                if (!this.isCompatible(left.getCurrentType(), pathPosition.getCurrentType())) {
                    invalid = true;
                }
                expressionTypes.add(ScalarTargetResolvingExpressionVisitor.typeName(pathPosition));
            }
            if (invalid) {
                this.invalid(predicate, "The in predicate compares the left type '" + ScalarTargetResolvingExpressionVisitor.typeName(left) + "' with different item types: " + expressionTypes);
            }
        }
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(ExistsPredicate predicate) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    private static String typeName(PathTargetResolvingExpressionVisitor.PathPosition p) {
        if (p == null || p.getCurrentType() == null) {
            return "null";
        }
        return p.getCurrentType().getJavaType().getName();
    }

    private boolean isCompatible(Type<?> t1, Type<?> t2) {
        TypeKind typeKind2;
        if (t1 == null || t2 == null) {
            return true;
        }
        if (t1 == t2) {
            return true;
        }
        Class t1Type = t1.getJavaType();
        Class t2Type = t2.getJavaType();
        TypeKind typeKind1 = TYPE_KINDS.get(t1Type);
        return typeKind1 == (typeKind2 = TYPE_KINDS.get(t2Type)) || t1Type == t2Type;
    }

    static {
        HashMap typeKinds = new HashMap();
        typeKinds.put(Boolean.TYPE, TypeKind.BOOLEAN);
        typeKinds.put(Boolean.class, TypeKind.BOOLEAN);
        typeKinds.put(Byte.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Byte.class, TypeKind.NUMERIC);
        typeKinds.put(Short.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Short.class, TypeKind.NUMERIC);
        typeKinds.put(Integer.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Integer.class, TypeKind.NUMERIC);
        typeKinds.put(Long.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Long.class, TypeKind.NUMERIC);
        typeKinds.put(Float.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Float.class, TypeKind.NUMERIC);
        typeKinds.put(Double.TYPE, TypeKind.NUMERIC);
        typeKinds.put(Double.class, TypeKind.NUMERIC);
        typeKinds.put(BigInteger.class, TypeKind.NUMERIC);
        typeKinds.put(BigDecimal.class, TypeKind.NUMERIC);
        typeKinds.put(Character.TYPE, TypeKind.STRING);
        typeKinds.put(Character.class, TypeKind.STRING);
        typeKinds.put(char[].class, TypeKind.STRING);
        typeKinds.put(Character[].class, TypeKind.STRING);
        typeKinds.put(Clob.class, TypeKind.STRING);
        typeKinds.put(NClob.class, TypeKind.STRING);
        typeKinds.put(String.class, TypeKind.STRING);
        TYPE_KINDS = typeKinds;
    }

    public static class TargetTypeImpl
    implements TargetType {
        private final boolean hasCollectionJoin;
        private final Attribute<?, ?> leafMethod;
        private final Class<?> leafBaseClass;
        private final Class<?> leafBaseKeyClass;
        private final Class<?> leafBaseValueClass;

        public TargetTypeImpl(boolean hasCollectionJoin, Attribute<?, ?> leafMethod, Class<?> leafBaseClass, Class<?> leafBaseKeyClass, Class<?> leafBaseValueClass) {
            this.hasCollectionJoin = hasCollectionJoin;
            this.leafMethod = leafMethod;
            this.leafBaseClass = leafBaseClass;
            this.leafBaseKeyClass = leafBaseKeyClass;
            this.leafBaseValueClass = leafBaseValueClass;
        }

        @Override
        public boolean hasCollectionJoin() {
            return this.hasCollectionJoin;
        }

        @Override
        public Attribute<?, ?> getLeafMethod() {
            return this.leafMethod;
        }

        @Override
        public Class<?> getLeafBaseClass() {
            return this.leafBaseClass;
        }

        @Override
        public Class<?> getLeafBaseKeyClass() {
            return this.leafBaseKeyClass;
        }

        @Override
        public Class<?> getLeafBaseValueClass() {
            return this.leafBaseValueClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetTypeImpl that = (TargetTypeImpl)o;
            if (this.leafBaseClass != null ? !this.leafBaseClass.equals(that.leafBaseClass) : that.leafBaseClass != null) {
                return false;
            }
            return this.leafBaseValueClass != null ? this.leafBaseValueClass.equals(that.leafBaseValueClass) : that.leafBaseValueClass == null;
        }

        public int hashCode() {
            int result = this.leafBaseClass != null ? this.leafBaseClass.hashCode() : 0;
            result = 31 * result + (this.leafBaseValueClass != null ? this.leafBaseValueClass.hashCode() : 0);
            return result;
        }
    }

    private static enum TypeKind {
        BOOLEAN,
        NUMERIC,
        STRING;

    }

    public static interface TargetType {
        public boolean hasCollectionJoin();

        public Attribute<?, ?> getLeafMethod();

        public Class<?> getLeafBaseClass();

        public Class<?> getLeafBaseKeyClass();

        public Class<?> getLeafBaseValueClass();
    }
}

