/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.SubqueryProviderFactory;
import java.lang.reflect.Constructor;
import java.util.Map;

public class ParameterizedSubqueryProviderFactory
implements SubqueryProviderFactory {
    private final Constructor<? extends SubqueryProvider> constructor;
    private final String[] parameterNames;

    public ParameterizedSubqueryProviderFactory(Constructor<? extends SubqueryProvider> constructor, String[] parameterNames) {
        this.constructor = constructor;
        this.parameterNames = parameterNames;
    }

    public boolean isParameterized() {
        return this.parameterNames.length > 0;
    }

    public SubqueryProvider create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters) {
        try {
            int size = this.parameterNames.length;
            Object[] args = new Object[size];
            for (int i = 0; i < size; ++i) {
                String name = this.parameterNames[i];
                args[i] = parameterHolder.isParameterSet(name) ? parameterHolder.getParameterValue(name) : optionalParameters.get(name);
            }
            return this.constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not instantiate the subquery provider: " + this.constructor.getDeclaringClass().getName(), ex);
        }
    }
}

