/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.lang.ValueHolder;
import com.blazebit.reflection.ExpressionUtils;
import com.blazebit.reflection.PropertyPathExpression;

public class PropertyPathExpressionValueHolder<X, Y>
implements ValueHolder<Y> {
    private final X source;
    private final PropertyPathExpression<X, Y> expression;

    public PropertyPathExpressionValueHolder(X source, String propertyPath) {
        this(source, ExpressionUtils.getExpression(source.getClass(), propertyPath));
    }

    public PropertyPathExpressionValueHolder(X source, PropertyPathExpression<X, Y> expression) {
        this.source = source;
        this.expression = expression;
    }

    @Override
    public Y getValue() {
        return this.expression.getValue(this.source);
    }

    public Y getNullSafeValue() {
        return this.expression.getNullSafeValue(this.source);
    }

    @Override
    public void setValue(Y value) {
        this.expression.setValue(this.source, value);
    }
}

